/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.VanillaChronicleUtils;
import net.openhft.chronicle.VanillaDateCache;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedCache;
import net.openhft.lang.model.constraints.NotNull;

public class VanillaIndexCache
implements Closeable {
    public static final String FILE_NAME_PREFIX = "index-";
    private final String basePath;
    private final File baseFile;
    private final IndexKey key = new IndexKey();
    private final int blockBits;
    private final VanillaDateCache dateCache;
    private final VanillaMappedCache<IndexKey> cache;
    private final int[][] appenderCycles;

    VanillaIndexCache(@NotNull ChronicleQueueBuilder.VanillaChronicleQueueBuilder builder, @NotNull VanillaDateCache dateCache, int blocksBits) {
        this.baseFile = builder.path();
        this.basePath = this.baseFile.getAbsolutePath();
        this.blockBits = blocksBits;
        this.dateCache = dateCache;
        this.cache = new VanillaMappedCache(builder.indexCacheCapacity(), true, builder.cleanupOnClose());
        int lastCycle = (int)this.lastCycle();
        int lastIndex = this.lastIndexFile(lastCycle);
        this.appenderCycles = new int[][]{{lastCycle, lastIndex}, {0, 0}};
    }

    public static long append(VanillaMappedBytes bytes, long indexValue, boolean synchronous) {
        if (bytes != null) {
            boolean endOfFile = false;
            long position = bytes.position();
            while (!endOfFile) {
                boolean bl = endOfFile = bytes.limit() - position < 8L;
                if (!endOfFile && bytes.compareAndSwapLong(position, 0L, indexValue)) {
                    bytes.lazyPosition(position + 8L);
                    if (synchronous) {
                        bytes.force();
                    }
                    return position;
                }
                position += 8L;
            }
        }
        return -1L;
    }

    public static long countIndices(VanillaMappedBytes buffer) {
        long indices = 0L;
        for (long offset = 0L; offset < buffer.capacity() && buffer.readLong(offset) != 0L; offset += 8L) {
            ++indices;
        }
        return indices;
    }

    public File fileFor(int cycle, int indexCount, boolean forAppend) throws IOException {
        return new File(new File(this.basePath, this.dateCache.formatFor(cycle)), FILE_NAME_PREFIX + indexCount);
    }

    public synchronized VanillaMappedBytes indexFor(int cycle, int indexCount, boolean forAppend) throws IOException {
        this.key.cycle = cycle;
        this.key.indexCount = indexCount << this.blockBits;
        VanillaMappedBytes vmb = this.cache.get(this.key);
        if (vmb == null) {
            vmb = this.cache.put(this.key.clone(), VanillaChronicleUtils.mkFiles(this.basePath, this.dateCache.formatFor(cycle), FILE_NAME_PREFIX + indexCount, forAppend), 1L << this.blockBits, indexCount);
        }
        vmb.reserve();
        return vmb;
    }

    @Override
    public synchronized void close() {
        this.cache.close();
    }

    int lastIndexFile(int cycle) {
        return this.lastIndexFile(cycle, 0);
    }

    int lastIndexFile(int cycle, int defaultCycle) {
        int maxIndex = -1;
        File cyclePath = new File(this.baseFile, this.dateCache.formatFor(cycle));
        File[] files = cyclePath.listFiles();
        if (files != null) {
            for (File file : files) {
                int index;
                String name = file.getName();
                if (!name.startsWith(FILE_NAME_PREFIX) || maxIndex >= (index = Integer.parseInt(name.substring(FILE_NAME_PREFIX.length())))) continue;
                maxIndex = index;
            }
        }
        return maxIndex != -1 ? maxIndex : defaultCycle;
    }

    public synchronized VanillaMappedBytes append(int cycle, long indexValue, boolean synchronous, long[] position) throws IOException {
        int localIndex = this.appenderCycles[0][1];
        int indexToUpdate = -1;
        if (this.appenderCycles[0][0] < cycle) {
            this.appenderCycles[1][0] = this.appenderCycles[0][0];
            this.appenderCycles[1][1] = this.appenderCycles[0][1];
            this.appenderCycles[0][0] = cycle;
            this.appenderCycles[0][1] = 0;
        } else if (this.appenderCycles[0][0] > cycle) {
            if (this.appenderCycles[1][0] == cycle) {
                localIndex = this.appenderCycles[1][1];
                indexToUpdate = 1;
            } else {
                localIndex = this.lastIndexFile(cycle, 0);
                indexToUpdate = -1;
            }
        }
        for (int indexCount = localIndex; indexCount < 10000; ++indexCount) {
            VanillaMappedBytes vmb = this.indexFor(cycle, indexCount, true);
            long position0 = VanillaIndexCache.append(vmb, indexValue, synchronous);
            if (position0 >= 0L) {
                position[0] = position0;
                if (indexToUpdate == 0 || indexToUpdate == 1) {
                    this.appenderCycles[indexToUpdate][1] = indexCount;
                }
                return vmb;
            }
            vmb.release();
        }
        throw new AssertionError();
    }

    public long firstCycle() {
        File[] files = this.baseFile.listFiles();
        if (files == null) {
            return -1L;
        }
        long firstDate = Long.MAX_VALUE;
        for (File file : files) {
            try {
                long date = this.dateCache.parseCount(file.getName());
                if (firstDate <= date) continue;
                firstDate = date;
            }
            catch (ParseException ignored) {
                // empty catch block
            }
        }
        return firstDate;
    }

    public long lastCycle() {
        File[] files = this.baseFile.listFiles();
        if (files == null) {
            return -1L;
        }
        long firstDate = Long.MIN_VALUE;
        for (File file : files) {
            try {
                long date = this.dateCache.parseCount(file.getName());
                if (firstDate >= date) continue;
                firstDate = date;
            }
            catch (ParseException ignored) {
                // empty catch block
            }
        }
        return firstDate;
    }

    public void checkCounts(int min, int max) {
        this.cache.checkCounts(min, max);
    }

    static class IndexKey
    implements Cloneable {
        int cycle;
        int indexCount;

        IndexKey() {
        }

        public int hashCode() {
            return this.cycle * 10191 ^ this.indexCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IndexKey)) {
                return false;
            }
            IndexKey key = (IndexKey)obj;
            return this.indexCount == key.indexCount && this.cycle == key.cycle;
        }

        protected IndexKey clone() {
            try {
                return (IndexKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public String toString() {
            return "IndexKey [cycle=" + this.cycle + "," + "indexCount=" + this.indexCount + "]";
        }
    }
}

