/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Set;
import net.openhft.chronicle.tcp.VanillaSelectionKeySet;
import net.openhft.chronicle.tools.ChronicleTools;
import net.openhft.lang.model.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaSelector
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VanillaSelector.class);
    private VanillaSelectionKeySet selectionKeySet = null;
    private Selector selector = null;

    public VanillaSelector open() throws IOException {
        this.selector = Selector.open();
        try {
            Class<?> selectorImplClass = Class.forName("sun.nio.ch.SelectorImpl", false, ChronicleTools.getSystemClassLoader());
            if (selectorImplClass.isAssignableFrom(this.selector.getClass())) {
                this.selectionKeySet = new VanillaSelectionKeySet();
                Field selectedKeysField = selectorImplClass.getDeclaredField("selectedKeys");
                selectedKeysField.setAccessible(true);
                Field publicSelectedKeysField = selectorImplClass.getDeclaredField("publicSelectedKeys");
                publicSelectedKeysField.setAccessible(true);
                selectedKeysField.set(this.selector, this.selectionKeySet);
                publicSelectedKeysField.set(this.selector, this.selectionKeySet);
            }
        }
        catch (Exception e) {
            LOGGER.error("", e);
        }
        return this;
    }

    public VanillaSelector register(@NotNull AbstractSelectableChannel channel, int ops) throws IOException {
        channel.register(this.selector, ops);
        return this;
    }

    public VanillaSelector register(@NotNull AbstractSelectableChannel channel, int ops, Object obj) throws IOException {
        channel.register(this.selector, ops, obj);
        return this;
    }

    public VanillaSelector deregister(@NotNull AbstractSelectableChannel channel, int ops) throws IOException {
        SelectionKey selectionKey = channel.keyFor(this.selector);
        if (selectionKey != null) {
            selectionKey.interestOps(selectionKey.interestOps() & ~ops);
        }
        return this;
    }

    VanillaSelectionKeySet vanillaSelectionKeys() {
        return this.selectionKeySet;
    }

    Set<SelectionKey> selectionKeys() {
        return this.selector.selectedKeys();
    }

    public int select(int spinLoopCount, long timeout) throws IOException {
        for (int i = 0; i < spinLoopCount; ++i) {
            int nbKeys = this.selector.selectNow();
            if (nbKeys == 0) continue;
            return nbKeys;
        }
        return this.selector.select(timeout);
    }

    @Override
    public void close() throws IOException {
        if (this.selector != null) {
            this.selector.close();
        }
    }
}

