/*
 * Decompiled with CFR 0.152.
 */
package reactor.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.processor.RingBufferWorkProcessor;

public class AsyncAppender
extends ContextAwareBase
implements Appender<ILoggingEvent>,
AppenderAttachable<ILoggingEvent>,
Subscriber<ILoggingEvent> {
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();
    private final FilterAttachableImpl<ILoggingEvent> fai = new FilterAttachableImpl();
    private final AtomicReference<Appender<ILoggingEvent>> delegate = new AtomicReference();
    private String name;
    private Processor<ILoggingEvent, ILoggingEvent> processor;
    private int backlog = 0x100000;
    private boolean includeCallerData = false;
    private boolean started = false;

    public long getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void doAppend(ILoggingEvent evt) throws LogbackException {
        if (this.getFilterChainDecision(evt) == FilterReply.DENY) {
            return;
        }
        evt.prepareForDeferredProcessing();
        if (this.includeCallerData) {
            evt.getCallerData();
        }
        try {
            this.queueLoggingEvent(evt);
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
    }

    @Override
    public void start() {
        this.startDelegateAppender();
        this.processor = RingBufferWorkProcessor.share("logger", this.backlog, false);
        this.processor.subscribe(this);
    }

    @Override
    public void onSubscribe(Subscription s) {
        try {
            this.doStart();
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
        finally {
            this.started = true;
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(ILoggingEvent iLoggingEvent) {
        this.aai.appendLoopOnAppenders(iLoggingEvent);
    }

    @Override
    public void onError(Throwable t) {
        this.addError(t.getMessage(), t);
    }

    @Override
    public void onComplete() {
        try {
            this.doStop();
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
        finally {
            this.started = false;
        }
    }

    private void startDelegateAppender() {
        Appender<ILoggingEvent> delegateAppender = this.delegate.get();
        if (null != delegateAppender && !delegateAppender.isStarted()) {
            delegateAppender.start();
        }
    }

    @Override
    public void stop() {
        if (null != this.delegate.get()) {
            this.delegate.get().stop();
        }
        this.aai.detachAndStopAllAppenders();
        this.processor.onComplete();
    }

    @Override
    public void addFilter(Filter<ILoggingEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public List<Filter<ILoggingEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    @Override
    public FilterReply getFilterChainDecision(ILoggingEvent event) {
        return this.fai.getFilterChainDecision(event);
    }

    @Override
    public void addAppender(Appender<ILoggingEvent> newAppender) {
        if (!this.delegate.compareAndSet(null, newAppender)) {
            throw new IllegalArgumentException(this.delegate.get() + " already attached.");
        }
        this.aai.addAppender(newAppender);
    }

    @Override
    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    @Override
    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    protected AppenderAttachableImpl<ILoggingEvent> getAppenderImpl() {
        return this.aai;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void queueLoggingEvent(ILoggingEvent evt) {
        if (null != this.delegate.get()) {
            this.processor.onNext(evt);
        }
    }
}

