/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.repo;

import com.izouma.awesomeAdmin.domain.Menu;
import com.izouma.awesomeAdmin.dto.MenuDTO;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface MenuRepo
extends JpaRepository<Menu, Long>,
JpaSpecificationExecutor<Menu> {
    @Query(nativeQuery=true, value="SELECT ifnull(max(sort + 1),1) FROM menu")
    public int nextSort();

    @Query(value="select m.category from Menu m group by m.category")
    public List<String> categories();

    @Transactional
    @Modifying
    @Query(value="delete from menu_authority where authority = ?1", nativeQuery=true)
    public int clearAuthority(String var1);

    @Transactional
    @Modifying
    @Query(value="insert into menu_authority value (?2, ?1)", nativeQuery=true)
    public int saveAuthority(String var1, Long var2);

    @Query(value="select * from menu     join menu_authority on menu.id = menu_authority.menu_id where authority in ?1 and active = 1 group by id", nativeQuery=true)
    public List<MenuDTO> authorityMenus(Iterable<String> var1);
}

