/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.izouma.awesomeAdmin.domain.User;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtUser
implements UserDetails {
    private static final long serialVersionUID = 5803985158027956021L;
    private final Collection<? extends GrantedAuthority> authorities;
    private final Date lastPasswordResetDate;
    private User user;

    public JwtUser(User user, Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
        this.lastPasswordResetDate = Date.from(user.getCreatedAt().atZone(ZoneId.systemDefault()).toInstant());
        this.user = user;
    }

    @JsonIgnore
    public Long getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @JsonIgnore
    public String getPassword() {
        return this.user.getPassword();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isEnabled() {
        return !this.user.isDel();
    }

    @JsonIgnore
    public Date getLastPasswordResetDate() {
        return this.lastPasswordResetDate;
    }

    public User getUser() {
        return this.user;
    }
}

