/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.security;

import com.izouma.awesomeAdmin.security.JwtAuthenticationEntryPoint;
import com.izouma.awesomeAdmin.security.JwtAuthorizationTokenFilter;
import com.izouma.awesomeAdmin.security.JwtConfig;
import com.izouma.awesomeAdmin.security.JwtUserDetailsService;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@EnableConfigurationProperties(value={JwtConfig.class})
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private JwtAuthenticationEntryPoint unauthorizedHandler;
    @Autowired
    private JwtUserDetailsService jwtUserDetailsService;
    @Autowired
    JwtAuthorizationTokenFilter authenticationTokenFilter;
    @Value(value="${jwt.header}")
    private String tokenHeader;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.jwtUserDetailsService).passwordEncoder(this.passwordEncoderBean());
    }

    @Bean
    public PasswordEncoder passwordEncoderBean() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)httpSecurity.csrf().disable()).cors().and()).authorizeRequests().antMatchers(new String[]{"/v2/api-docs", "/swagger-ui.html", "/swagger-resources/**", "/webjars/**"})).permitAll().antMatchers(new String[]{"/user/register"})).permitAll().antMatchers(new String[]{"/upload/**"})).permitAll().antMatchers(new String[]{"/files/**"})).permitAll().antMatchers(new String[]{"/static/**"})).permitAll().antMatchers(new String[]{"/auth/**"})).permitAll().antMatchers(new String[]{"/captcha/**"})).permitAll().antMatchers(new String[]{"/admin/**"})).permitAll().antMatchers(new String[]{"/systemVariable/all"})).permitAll().antMatchers(new String[]{"/**/excel"})).permitAll().antMatchers(new String[]{"/wx/**"})).permitAll().antMatchers(new String[]{"/sms/sendVerify"})).permitAll().antMatchers(new String[]{"/error"})).permitAll().antMatchers(new String[]{"/401"})).permitAll().antMatchers(new String[]{"/404"})).permitAll().antMatchers(new String[]{"/500"})).permitAll().antMatchers(new String[]{"/MP_verify*"})).permitAll().antMatchers(new String[]{"/word2pdf"})).permitAll().anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.unauthorizedHandler).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        httpSecurity.addFilterBefore((Filter)this.authenticationTokenFilter, UsernamePasswordAuthenticationFilter.class);
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/auth/**"})).and().ignoring().antMatchers(HttpMethod.GET, new String[]{"/", "/*.html", "/**/favicon.ico", "/**/*.html", "/**/*.css", "/**/*.js"});
    }
}

