/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.service;

import com.izouma.awesomeAdmin.dto.Captcha;
import com.wf.captcha.SpecCaptcha;
import java.awt.FontFormatException;
import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.UserManagedCache;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.springframework.stereotype.Service;

@Service
public class CaptchaService {
    private final UserManagedCache<String, String> captchaCache = UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, String.class).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofMinutes(10L))).build(true);

    public Captcha gen() throws IOException, FontFormatException {
        String key = UUID.randomUUID().toString();
        SpecCaptcha specCaptcha = new SpecCaptcha(180, 64, 5);
        specCaptcha.setFont(6, 48.0f);
        String code = specCaptcha.text().toLowerCase();
        String image = specCaptcha.toBase64();
        this.captchaCache.put((Object)key, (Object)code);
        return new Captcha(key, image);
    }

    public boolean verify(String key, String code) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)code)) {
            return false;
        }
        code = code.toLowerCase();
        boolean verify = false;
        String trueCode = (String)this.captchaCache.get((Object)key);
        if (StringUtils.isNotBlank((CharSequence)trueCode) && trueCode.equals(code)) {
            verify = true;
        }
        return verify;
    }
}

