/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.service;

import com.alibaba.fastjson.JSON;
import com.github.kevinsawicki.http.HttpRequest;
import com.izouma.awesomeAdmin.domain.District;
import com.izouma.awesomeAdmin.enums.DistrictLevel;
import com.izouma.awesomeAdmin.repo.DistrictRepo;
import com.izouma.awesomeAdmin.service.DistrictService;
import com.izouma.awesomeAdmin.utils.amap.DistrictsItem;
import com.izouma.awesomeAdmin.utils.amap.QueryDistrictResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DistrictService {
    private final DistrictRepo districtRepo;

    public List<District> get(DistrictLevel level, DistrictLevel maxLevel, Long parent) {
        return this.districtRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (level != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("level"), (Object)level));
            }
            if (parent != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("parent"), (Object)parent));
            }
            if (maxLevel != null) {
                List list = Arrays.stream(DistrictLevel.values()).filter(l -> l.getValue() <= maxLevel.getValue()).collect(Collectors.toList());
                if (list.isEmpty()) {
                    predicates.add(criteriaBuilder.equal((Expression)root.get("level"), (Object)DistrictLevel.NONE));
                } else {
                    predicates.add(root.get("level").in(list));
                }
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }).stream().peek(district -> {
            if (maxLevel != null) {
                int childCount = 0;
                switch (1.$SwitchMap$com$izouma$awesomeAdmin$enums$DistrictLevel[maxLevel.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        childCount = district.getCityCount();
                        break;
                    }
                    case 3: {
                        childCount = district.getCityCount() + district.getDistrictCount();
                        break;
                    }
                    case 4: {
                        childCount = district.getCityCount() + district.getDistrictCount() + district.getStreetCount();
                    }
                }
                district.setLeaf(Boolean.valueOf(childCount == 0));
            } else {
                district.setLeaf(Boolean.valueOf(district.getChildCount() == 0));
            }
        }).collect(Collectors.toList());
    }

    public void sync() {
        QueryDistrictResponse response = (QueryDistrictResponse)JSON.parseObject((String)HttpRequest.get((CharSequence)"https://restapi.amap.com/v3/config/district?key=3d59fb422c5c13af59bf82a8b6f3ad54&subdistrict=4").body(), QueryDistrictResponse.class);
        ((Stream)((DistrictsItem)response.getDistricts().get(0)).getDistricts().stream().parallel()).forEach(item -> this.saveDistrict(item, null));
    }

    private void saveDistrict(DistrictsItem item, Long parentId) {
        District district = District.builder().id(Long.valueOf(Long.parseLong(item.getAdcode()))).name(item.getName()).parent(parentId).level(DistrictLevel.valueOf((String)item.getLevel().toUpperCase())).build();
        if (district.getLevel() == DistrictLevel.STREET) {
            district.setId(Long.valueOf(Long.parseLong(district.getId() + String.format("%02d", item.getIdx()))));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getCenter())) {
            String[] arr = item.getCenter().split(",");
            district.setLng(Double.parseDouble(arr[0]));
            district.setLat(Double.parseDouble(arr[1]));
        }
        if (item.getCitycode() != null && item.getCitycode() instanceof String) {
            district.setCityCode((String)item.getCitycode());
        }
        if (item.getDistricts() != null) {
            district.setChildCount(item.getDistricts().size());
            district.setCityCount((int)item.getDistricts().stream().filter(d -> DistrictLevel.valueOf((String)d.getLevel().toUpperCase()) == DistrictLevel.CITY).count());
            district.setDistrictCount((int)item.getDistricts().stream().filter(d -> DistrictLevel.valueOf((String)d.getLevel().toUpperCase()) == DistrictLevel.DISTRICT).count());
            district.setStreetCount((int)item.getDistricts().stream().filter(d -> DistrictLevel.valueOf((String)d.getLevel().toUpperCase()) == DistrictLevel.STREET).count());
        } else {
            district.setChildCount(0);
        }
        this.districtRepo.save((Object)district);
        if (item.getDistricts() != null) {
            int[] idx = new int[]{1};
            ((Stream)item.getDistricts().stream().parallel()).forEach(child -> {
                int n = idx[0];
                idx[0] = n + 1;
                child.setIdx(n);
                this.saveDistrict(child, district.getId());
            });
        }
    }

    public DistrictService(DistrictRepo districtRepo) {
        this.districtRepo = districtRepo;
    }
}

