/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.service;

import com.izouma.awesomeAdmin.dto.gen.GenCode;
import com.izouma.awesomeAdmin.dto.gen.TableField;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GenCodeService {
    private static final Logger log = LoggerFactory.getLogger(GenCodeService.class);
    @Autowired
    private Configuration cfg;

    public void genController(GenCode model) throws IOException, TemplateException {
        Path targetFile = StringUtils.isNotBlank((String)model.getGenPackage()) ? Paths.get(model.getJavaPath(), "web", model.getGenPackage(), model.getClassName() + "Controller.java").toAbsolutePath() : Paths.get(model.getJavaPath(), "web", model.getClassName() + "Controller.java").toAbsolutePath();
        HashMap<String, Serializable> extra = new HashMap<String, Serializable>();
        if (StringUtil.isNotEmpty((CharSequence)model.getGenPackage())) {
            ArrayList<String> imports = new ArrayList<String>();
            imports.add("import " + model.getBasePackage() + ".web.BaseController;");
            extra.put("imports", imports);
        }
        extra.put("subPackage", Boolean.valueOf(StringUtil.isNotEmpty((CharSequence)model.getGenPackage())));
        extra.put("softDelete", Boolean.valueOf(this.canSoftDelete(model)));
        this.genFile("ControllerTemplate.ftl", model, extra, targetFile);
        log.info("\u6210\u529f\u751f\u6210Controller:{}", (Object)targetFile.toString());
    }

    public void genService(GenCode model) throws IOException, TemplateException {
        Path targetFile = StringUtils.isNotBlank((String)model.getGenPackage()) ? Paths.get(model.getJavaPath(), "service", model.getGenPackage(), model.getClassName() + "Service.java").toAbsolutePath() : Paths.get(model.getJavaPath(), "service", model.getClassName() + "Service.java").toAbsolutePath();
        HashMap<String, Boolean> extra = new HashMap<String, Boolean>();
        extra.put("softDelete", this.canSoftDelete(model));
        this.genFile("ServiceTemplate.ftl", model, extra, targetFile);
        log.info("\u6210\u529f\u751f\u6210Service:{}", (Object)targetFile.toString());
    }

    public void genRepo(GenCode model) throws IOException, TemplateException, ClassNotFoundException {
        Path targetFile = StringUtils.isNotBlank((String)model.getGenPackage()) ? Paths.get(model.getJavaPath(), "repo", model.getGenPackage(), model.getClassName() + "Repo.java").toAbsolutePath() : Paths.get(model.getJavaPath(), "repo", model.getClassName() + "Repo.java").toAbsolutePath();
        HashMap<String, Boolean> extra = new HashMap<String, Boolean>();
        extra.put("softDelete", this.canSoftDelete(model));
        this.genFile("RepoTemplate.ftl", model, extra, targetFile);
        log.info("\u6210\u529f\u751f\u6210Repo:{}", (Object)targetFile.toString());
    }

    public void genListView(GenCode model) throws IOException, TemplateException {
        Path targetFile = Paths.get(model.getViewPath(), model.getClassName() + "List.vue").toAbsolutePath();
        HashMap<String, Boolean> extra = new HashMap<String, Boolean>();
        extra.put("softDelete", this.canSoftDelete(model));
        this.genFile("ListViewTemplate.ftl", model, extra, targetFile);
        log.info("\u6210\u529f\u751f\u6210ListView:{}", (Object)targetFile.toString());
    }

    public void genEditView(GenCode model) throws IOException, TemplateException, FontFormatException {
        Path targetFile = Paths.get(model.getViewPath(), model.getClassName() + "Edit.vue").toAbsolutePath();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int maxLabelWidth = 0;
        for (TableField field : model.getFields()) {
            String label = StringUtils.isEmpty((String)field.getRemark()) ? field.getModelName() : field.getRemark();
            int labelWidth = this.measureText(label, 14.0f);
            if (labelWidth <= maxLabelWidth) continue;
            maxLabelWidth = labelWidth;
        }
        map.put("labelWidth", maxLabelWidth + 25 + "px");
        map.put("softDelete", this.canSoftDelete(model));
        this.genFile("EditViewTemplate.ftl", model, map, targetFile);
        log.info("\u6210\u529f\u751f\u6210EditView:{}", (Object)targetFile.toString());
    }

    private void genFile(String template, GenCode model, Map<String, Object> extraData, Path path) throws IOException, TemplateException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("model", model);
        if (extraData != null) {
            data.putAll(extraData);
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Template temp = this.cfg.getTemplate(template);
        FileWriter out = new FileWriter(path.toString());
        temp.process(data, (Writer)out);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private int measureText(String text, float fontSize) throws IOException, FontFormatException {
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        Font font = Font.createFont(0, this.getClass().getResourceAsStream("/font/SourceHanSansCN-Normal.ttf"));
        return (int)font.deriveFont(fontSize).getStringBounds(text, frc).getWidth();
    }

    public void genRouter(GenCode model) {
        try {
            File file = new File(model.getRouterPath(), "router.js");
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringBuilder routerJs = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                routerJs.append(line).append("\n");
            }
            reader.close();
            int insertLocation = routerJs.indexOf("/**INSERT_LOCATION**/");
            if (insertLocation > -1) {
                boolean needComma;
                String remark = model.getRemark();
                String routeName = StringUtils.capitalize((String)model.getClassName());
                String routePath = StringUtils.uncapitalize((String)model.getClassName());
                String route = "{\n                    path: '/" + routePath + "Edit',\n                    name: '" + routeName + "Edit',\n                    component: () => import(/* webpackChunkName: \"" + routePath + "Edit\" */ '@/views/" + routeName + "Edit.vue'),\n                    meta: {\n                       title: '" + remark + "\u7f16\u8f91',\n                    },\n                },\n                {\n                    path: '/" + routePath + "List',\n                    name: '" + routeName + "List',\n                    component: () => import(/* webpackChunkName: \"" + routePath + "List\" */ '@/views/" + routeName + "List.vue'),\n                    meta: {\n                       title: '" + remark + "',\n                    },\n               }\n                ";
                boolean bl = needComma = !routerJs.toString().substring(0, insertLocation).trim().endsWith(",");
                if (needComma) {
                    routerJs.insert(routerJs.toString().substring(0, insertLocation).lastIndexOf("}") + 1, ",");
                    ++insertLocation;
                }
                routerJs.insert(insertLocation, route);
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(routerJs.toString().trim().getBytes());
            bufferedOutputStream.close();
            System.out.println("\u6210\u529f\u751f\u6210\u8def\u7531:" + file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean canSoftDelete(GenCode model) {
        return true;
    }
}

