/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.service.storage;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.service.storage.StorageService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;

@Service
@EnableConfigurationProperties
@ConfigurationProperties(prefix="aliyun")
@ConditionalOnProperty(name={"storage.provider"}, havingValue="aliyun")
public class AliStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(AliStorageService.class);
    private String accessKeyId;
    private String accessKeySecret;
    private String ossBucketName;
    private String ossEndPoint;
    private String ossDomain;

    public String uploadFromInputStream(InputStream inputStream, String path) {
        log.info("\u963f\u91cc\u4e91OSS\u4e0a\u4f20: inputStream -> {}", (Object)path);
        try {
            String result = this.upload(inputStream, path);
            log.info("\u4e0a\u4f20\u6210\u529f {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91OSS\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25", e.getMessage());
        }
    }

    public String uploadFromUrl(String url, String path) {
        log.info("\u963f\u91cc\u4e91OSS\u4e0a\u4f20: {} -> {}", (Object)url, (Object)path);
        try {
            InputStream inputStream = new URL(url).openStream();
            String result = this.upload(inputStream, path);
            log.info("\u4e0a\u4f20\u6210\u529f {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("\u963f\u91cc\u4e91OSS\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25", e.getMessage());
        }
    }

    private String upload(InputStream inputStream, String path) {
        OSSClient client = new OSSClient(this.ossEndPoint, this.accessKeyId, this.accessKeySecret);
        ObjectMetadata metadata = new ObjectMetadata();
        client.putObject(this.ossBucketName, path, inputStream, metadata);
        client.shutdown();
        try {
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.ossDomain + "/" + path;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getOssBucketName() {
        return this.ossBucketName;
    }

    public String getOssEndPoint() {
        return this.ossEndPoint;
    }

    public String getOssDomain() {
        return this.ossDomain;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setOssBucketName(String ossBucketName) {
        this.ossBucketName = ossBucketName;
    }

    public void setOssEndPoint(String ossEndPoint) {
        this.ossEndPoint = ossEndPoint;
    }

    public void setOssDomain(String ossDomain) {
        this.ossDomain = ossDomain;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AliStorageService)) {
            return false;
        }
        AliStorageService other = (AliStorageService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$ossBucketName = this.getOssBucketName();
        String other$ossBucketName = other.getOssBucketName();
        if (this$ossBucketName == null ? other$ossBucketName != null : !this$ossBucketName.equals(other$ossBucketName)) {
            return false;
        }
        String this$ossEndPoint = this.getOssEndPoint();
        String other$ossEndPoint = other.getOssEndPoint();
        if (this$ossEndPoint == null ? other$ossEndPoint != null : !this$ossEndPoint.equals(other$ossEndPoint)) {
            return false;
        }
        String this$ossDomain = this.getOssDomain();
        String other$ossDomain = other.getOssDomain();
        return !(this$ossDomain == null ? other$ossDomain != null : !this$ossDomain.equals(other$ossDomain));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AliStorageService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $ossBucketName = this.getOssBucketName();
        result = result * 59 + ($ossBucketName == null ? 43 : $ossBucketName.hashCode());
        String $ossEndPoint = this.getOssEndPoint();
        result = result * 59 + ($ossEndPoint == null ? 43 : $ossEndPoint.hashCode());
        String $ossDomain = this.getOssDomain();
        result = result * 59 + ($ossDomain == null ? 43 : $ossDomain.hashCode());
        return result;
    }

    public String toString() {
        return "AliStorageService(accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", ossBucketName=" + this.getOssBucketName() + ", ossEndPoint=" + this.getOssEndPoint() + ", ossDomain=" + this.getOssDomain() + ")";
    }
}

