/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.utils;

import com.izouma.awesomeAdmin.annotations.Searchable;
import com.izouma.awesomeAdmin.dto.PageQuery;
import com.izouma.awesomeAdmin.utils.DateTimeUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

/*
 * Exception performing whole class analysis ignored.
 */
public class JpaUtils {
    private static final Logger log = LoggerFactory.getLogger(JpaUtils.class);

    public static PageRequest toPageRequest(PageQuery pageQuery) {
        PageRequest pageRequest;
        if (StringUtils.isNotEmpty((CharSequence)pageQuery.getSort())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (String sortStr : pageQuery.getSort().split(";")) {
                String direction = "asc";
                String prop = sortStr;
                if (sortStr.contains(",asc") || sortStr.contains(",desc")) {
                    prop = sortStr.split(",")[0];
                    direction = sortStr.split(",")[1];
                }
                orders.add("asc".equals(direction) ? Sort.Order.asc((String)prop) : Sort.Order.desc((String)prop));
            }
            pageRequest = PageRequest.of((int)pageQuery.getPage(), (int)pageQuery.getSize(), (Sort)Sort.by(orders));
        } else {
            pageRequest = PageRequest.of((int)pageQuery.getPage(), (int)pageQuery.getSize());
        }
        return pageRequest;
    }

    public static <T> Specification<T> toSpecification(PageQuery pageQuery, Class<?> queryClass) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            List and = JpaUtils.toPredicates((PageQuery)pageQuery, (Class)queryClass, (Root)root, (CriteriaQuery)criteriaQuery, (CriteriaBuilder)criteriaBuilder);
            return criteriaBuilder.and(and.toArray(new Predicate[0]));
        };
    }

    public static <T> List<Predicate> toPredicates(PageQuery pageQuery, Class<?> queryClass, Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        ArrayList<Predicate> and = new ArrayList<Predicate>();
        pageQuery.getQuery().forEach((property, value) -> {
            if (value == null) {
                return;
            }
            if (String.class.equals(value.getClass()) && StringUtils.isEmpty((CharSequence)((String)value))) {
                return;
            }
            Field field = JpaUtils.getDeclaredField((Class)queryClass, (String)property);
            if (field == null) {
                return;
            }
            Class<?> fieldType = field.getType();
            if (Enum.class.isAssignableFrom(fieldType)) {
                if (value instanceof Collection) {
                    if (!((Collection)value).isEmpty()) {
                        ArrayList list = new ArrayList();
                        for (Object o : (Collection)value) {
                            list.add(Enum.valueOf(fieldType, String.valueOf(o)));
                        }
                        and.add(root.get(property).in(list));
                    }
                } else if (value instanceof String && StringUtils.isNotEmpty((CharSequence)((String)value))) {
                    if (((String)value).contains(",")) {
                        String[] arr = ((String)value).split(",");
                        ArrayList list = new ArrayList();
                        for (String s : arr) {
                            list.add(Enum.valueOf(fieldType, s));
                        }
                        and.add(root.get(property).in(list));
                    } else {
                        and.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(property), Enum.valueOf(fieldType, String.valueOf(value)))}));
                    }
                }
            } else if (LocalDateTime.class == fieldType) {
                if (value instanceof List) {
                    List list = (List)value;
                    if (list.size() == 1) {
                        LocalDateTime start = DateTimeUtils.toLocalDateTime((String)((String)list.get(0)), (String)"yyyy-MM-dd HH:mm:ss");
                        and.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(property), (Comparable)start));
                    } else if (list.size() == 2) {
                        LocalDateTime end = DateTimeUtils.toLocalDateTime((String)((String)list.get(1)), (String)"yyyy-MM-dd HH:mm:ss");
                        and.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(property), (Comparable)end));
                    }
                } else if (value instanceof String && Pattern.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$", (String)value)) {
                    String[] arr = ((String)value).split(",");
                    LocalDateTime start = DateTimeUtils.toLocalDateTime((String)arr[0], (String)"yyyy-MM-dd HH:mm:ss");
                    and.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(property), (Comparable)start));
                    LocalDateTime end = DateTimeUtils.toLocalDateTime((String)arr[1], (String)"yyyy-MM-dd HH:mm:ss");
                    and.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(property), (Comparable)end));
                } else {
                    and.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(property), (Object)DateTimeUtils.toLocalDateTime((String)((String)value), (String)"yyyy-MM-dd HH:mm:ss"))}));
                }
            } else if (LocalDate.class == fieldType) {
                if (value instanceof List) {
                    List list = (List)value;
                    if (list.size() == 1) {
                        LocalDate start = DateTimeUtils.toLocalDate((String)((String)list.get(0)), (String)"yyyy-MM-dd");
                        and.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(property), (Comparable)start));
                    } else if (list.size() == 2) {
                        LocalDate end = DateTimeUtils.toLocalDate((String)((String)list.get(1)), (String)"yyyy-MM-dd");
                        and.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(property), (Comparable)end));
                    }
                } else if (value instanceof String && Pattern.matches("^\\d{4}-\\d{2}-\\d{2},\\d{4}-\\d{2}-\\d{2}$", (String)value)) {
                    String[] arr = ((String)value).split(",");
                    LocalDate start = DateTimeUtils.toLocalDate((String)arr[0], (String)"yyyy-MM-dd");
                    and.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(property), (Comparable)start));
                    LocalDate end = DateTimeUtils.toLocalDate((String)arr[1], (String)"yyyy-MM-dd");
                    and.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(property), (Comparable)end));
                } else {
                    and.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(property), (Object)DateTimeUtils.toLocalDateTime((String)((String)value), (String)"yyyy-MM-dd"))}));
                }
            } else {
                and.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(property), value)}));
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)pageQuery.getSearch())) {
            Field[] fields = queryClass.getDeclaredFields();
            ArrayList<Predicate> or = new ArrayList<Predicate>();
            try {
                if (StringUtils.isNumeric((CharSequence)pageQuery.getSearch())) {
                    or.add(criteriaBuilder.equal((Expression)root.get("id"), (Object)Long.parseLong(pageQuery.getSearch())));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Field field : fields) {
                Searchable annotation = field.getAnnotation(Searchable.class);
                if (annotation == null || !annotation.value()) continue;
                or.add(criteriaBuilder.like((Expression)root.get(field.getName()), "%" + pageQuery.getSearch() + "%"));
            }
            and.add(criteriaBuilder.or(or.toArray(new Predicate[0])));
        }
        return and;
    }

    private static Field getDeclaredField(Class<?> clazz, String property) {
        String className = clazz.getName();
        while (clazz != null && clazz != Object.class) {
            try {
                return clazz.getDeclaredField(property);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        log.error("no such field [{}] in class [{}]", (Object)property, (Object)className);
        return null;
    }
}

