/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AppErrorController
implements ErrorController {
    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public String handleError(HttpServletRequest request, Model model) {
        Object status = request.getAttribute("javax.servlet.error.status_code");
        if (status != null) {
            int statusCode = Integer.parseInt(status.toString());
            if (statusCode == HttpStatus.NOT_FOUND.value()) {
                return "commons/404";
            }
            if (statusCode == HttpStatus.UNAUTHORIZED.value()) {
                return "commons/401";
            }
            if (statusCode == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
                return "commons/500";
            }
        }
        return "commons/error";
    }

    @RequestMapping(value={"/401"})
    public String error401() {
        return "commons/401";
    }

    @RequestMapping(value={"/404"})
    public String error404() {
        return "commons/404";
    }

    @RequestMapping(value={"/500"})
    public String error500() {
        return "commons/500";
    }
}

