/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.izouma.awesomeAdmin.domain.User;
import com.izouma.awesomeAdmin.enums.AuthorityName;
import com.izouma.awesomeAdmin.exception.AuthenticationException;
import com.izouma.awesomeAdmin.security.JwtTokenUtil;
import com.izouma.awesomeAdmin.security.JwtUser;
import com.izouma.awesomeAdmin.security.JwtUserFactory;
import com.izouma.awesomeAdmin.service.UserService;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AuthenticationController {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationController.class);
    private final AuthenticationManager authenticationManager;
    private final JwtTokenUtil jwtTokenUtil;
    private final UserService userService;

    @PostMapping(value={"/login"})
    public String loginByUserPwd(String username, String password, Integer expiration) {
        Authentication authentication = this.authenticate(username, password);
        JwtUser jwtUser = (JwtUser)authentication.getPrincipal();
        return this.jwtTokenUtil.generateToken((UserDetails)jwtUser);
    }

    @PostMapping(value={"/loginAdmin"})
    public String loginByUserPwdAdmin(String username, String password, Integer expiration) {
        Authentication authentication = this.authenticate(username, password);
        if (!authentication.getAuthorities().contains(new SimpleGrantedAuthority(AuthorityName.ROLE_ADMIN.name()))) {
            throw new AuthenticationException("\u7981\u6b62\u767b\u5f55", null);
        }
        JwtUser jwtUser = (JwtUser)authentication.getPrincipal();
        return this.jwtTokenUtil.generateToken((UserDetails)jwtUser);
    }

    @PostMapping(value={"/phoneLogin"})
    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55")
    public String phoneLogin(String phone) {
        try {
            User user = this.userService.loginByPhone(phone);
            return this.jwtTokenUtil.generateToken((UserDetails)JwtUserFactory.create((User)user));
        }
        catch (Exception e) {
            log.error("loginByPhone", (Throwable)e);
            throw new AuthenticationException("\u767b\u9646\u9519\u8bef", (Throwable)e);
        }
    }

    @PostMapping(value={"/mpLogin"})
    @ApiOperation(value="\u516c\u4f17\u53f7\u767b\u5f55")
    public String mpLogin(String code) {
        try {
            User user = this.userService.loginMp(code);
            return this.jwtTokenUtil.generateToken((UserDetails)JwtUserFactory.create((User)user));
        }
        catch (Exception e) {
            log.error("loginByCode", (Throwable)e);
            throw new AuthenticationException("\u767b\u9646\u9519\u8bef", (Throwable)e);
        }
    }

    @PostMapping(value={"/maLogin"})
    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u767b\u5f55")
    public String maLogin(String code) {
        try {
            User user = this.userService.loginMa(code);
            return this.jwtTokenUtil.generateToken((UserDetails)JwtUserFactory.create((User)user));
        }
        catch (Exception e) {
            log.error("loginByCode", (Throwable)e);
            throw new AuthenticationException("\u767b\u9646\u9519\u8bef", (Throwable)e);
        }
    }

    private Authentication authenticate(String username, String password) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        try {
            return this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        }
        catch (DisabledException e) {
            throw new AuthenticationException("\u7981\u6b62\u767b\u5f55", (Throwable)e);
        }
        catch (BadCredentialsException e) {
            throw new AuthenticationException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", (Throwable)e);
        }
    }

    public AuthenticationController(AuthenticationManager authenticationManager, JwtTokenUtil jwtTokenUtil, UserService userService) {
        this.authenticationManager = authenticationManager;
        this.jwtTokenUtil = jwtTokenUtil;
        this.userService = userService;
    }
}

