/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.izouma.awesomeAdmin.utils.ObjUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestController
@RequestMapping(value={"/dev"})
public class DevelopController {
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    @GetMapping(value={"/entities"})
    public List entities() {
        ArrayList entities = new ArrayList();
        Reflections reflections = new Reflections(this.getClass().getPackage().getName().replace(".web", ".domain"), new Scanner[0]);
        Set entitySet = reflections.getTypesAnnotatedWith(Entity.class);
        for (Class entity : entitySet) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", entity.getSimpleName());
            map.put("package", entity.getName());
            entities.add(map);
        }
        return entities;
    }

    @GetMapping(value={"/getFields"})
    public String[] getFields(@RequestParam String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ObjUtils.getFields(Class.forName(className).newInstance().getClass());
    }

    @GetMapping(value={"/mappings"})
    @ResponseBody
    public List list() {
        ArrayList urlList = new ArrayList();
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry m : map.entrySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            RequestMappingInfo info = (RequestMappingInfo)m.getKey();
            HandlerMethod method = (HandlerMethod)m.getValue();
            PatternsRequestCondition p = info.getPatternsCondition();
            for (String url : p.getPatterns()) {
                hashMap.put("url", url);
            }
            hashMap.put("className", method.getMethod().getDeclaringClass().getName());
            hashMap.put("method", method.getMethod().getName());
            RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
            String type = methodsCondition.toString();
            if (type != null && type.startsWith("[") && type.endsWith("]")) {
                type = type.substring(1, type.length() - 1);
                hashMap.put("type", type);
            }
            urlList.add(hashMap);
        }
        return urlList;
    }

    @GetMapping(value={"/selectMappings"})
    @ResponseBody
    public List selectMappings() {
        ArrayList urlList = new ArrayList();
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry m : map.entrySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            RequestMappingInfo info = (RequestMappingInfo)m.getKey();
            HandlerMethod method = (HandlerMethod)m.getValue();
            PatternsRequestCondition p = info.getPatternsCondition();
            for (String url : p.getPatterns()) {
                hashMap.put("url", url);
            }
            urlList.add(hashMap);
        }
        return urlList;
    }
}

