/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.izouma.awesomeAdmin.domain.BaseEntity;
import com.izouma.awesomeAdmin.domain.Menu;
import com.izouma.awesomeAdmin.enums.AuthorityName;
import com.izouma.awesomeAdmin.repo.MenuRepo;
import com.izouma.awesomeAdmin.security.Authority;
import com.izouma.awesomeAdmin.web.BaseController;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/menu"})
public class MenuController
extends BaseController {
    private final MenuRepo menuRepo;

    @GetMapping(value={"/userMenu"})
    public List<Menu> userMenu() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        List menuList = this.menuRepo.authorityMenus((Iterable)authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList())).stream().map(Menu::from).collect(Collectors.toList());
        ArrayList<Menu> root = new ArrayList<Menu>();
        for (Menu menu : menuList) {
            if (menu.getRoot().booleanValue()) {
                root.add(menu);
                continue;
            }
            Menu parent = menuList.stream().filter(m -> m.getId().equals(menu.getParent())).findAny().orElse(null);
            if (parent == null) continue;
            if (parent.getChildren() == null) {
                parent.setChildren(new ArrayList());
            }
            parent.getChildren().add(menu);
        }
        this.sortMenu(root);
        return root;
    }

    @GetMapping(value={"/authority/{name}/get"})
    public List<Long> getAuthorityMenus(@PathVariable String name) {
        return this.menuRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(criteriaBuilder.isMember((Object)Authority.get((AuthorityName)AuthorityName.valueOf((String)name)), (Expression)root.get("authorities")));
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }).stream().map(BaseEntity::getId).collect(Collectors.toList());
    }

    @PostMapping(value={"/authority/{name}/save"})
    public void saveAuthorityMenus(@PathVariable String name, @RequestBody List<Long> ids) {
        this.menuRepo.clearAuthority(name);
        ((Stream)ids.stream().parallel()).forEach(id -> this.menuRepo.saveAuthority(name, id));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/all"})
    public List<Menu> all(String category) {
        List menuList = this.menuRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(criteriaBuilder.equal((Expression)root.get("root"), (Object)true));
            if (StringUtils.isNotBlank((CharSequence)category)) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("category"), (Object)category));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        });
        this.sortMenu(menuList);
        return menuList;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/save"})
    public Menu save(@RequestBody Menu menu) {
        if (menu.getSort() == null) {
            menu.setSort(Integer.valueOf(this.menuRepo.nextSort()));
        }
        this.menuRepo.save((Object)menu);
        return menu;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/groupByCategory"})
    public Map<String, List<Menu>> groupByCategory() {
        return this.menuRepo.findAll().stream().filter(menu -> menu.getCategory() != null).collect(Collectors.groupingBy(Menu::getCategory));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/categories"})
    public List<String> categories() {
        return this.menuRepo.categories().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private void sortMenu(List<Menu> menus) {
        menus.sort(Comparator.comparingInt(Menu::getSort));
        for (Menu menu : menus) {
            if (menu.getChildren() == null) continue;
            this.sortMenu(menu.getChildren());
        }
    }

    public MenuController(MenuRepo menuRepo) {
        this.menuRepo = menuRepo;
    }
}

