/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.izouma.awesomeAdmin.domain.TestClass;
import com.izouma.awesomeAdmin.dto.PageQuery;
import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.repo.TestClassRepo;
import com.izouma.awesomeAdmin.service.TestClassService;
import com.izouma.awesomeAdmin.utils.ObjUtils;
import com.izouma.awesomeAdmin.utils.excel.ExcelUtils;
import com.izouma.awesomeAdmin.web.BaseController;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testClass"})
public class TestClassController
extends BaseController {
    private TestClassService testClassService;
    private TestClassRepo testClassRepo;

    @PostMapping(value={"/save"})
    public TestClass save(@RequestBody TestClass record) {
        if (record.getId() != null) {
            TestClass orig = (TestClass)this.testClassRepo.findById((Object)record.getId()).orElseThrow(new BusinessException("\u65e0\u8bb0\u5f55"));
            ObjUtils.merge((Object)orig, (Object)record);
            return (TestClass)this.testClassRepo.save((Object)orig);
        }
        return (TestClass)this.testClassRepo.save((Object)record);
    }

    @PostMapping(value={"/all"})
    public Page<TestClass> all(@RequestBody PageQuery pageQuery) {
        return this.testClassService.all(pageQuery);
    }

    @GetMapping(value={"/get/{id}"})
    public TestClass get(@PathVariable Long id) {
        return (TestClass)this.testClassRepo.findById((Object)id).orElseThrow(new BusinessException("\u65e0\u8bb0\u5f55"));
    }

    @PostMapping(value={"/del/{id}"})
    public void del(@PathVariable Long id) {
        this.testClassRepo.softDelete(id);
    }

    @GetMapping(value={"/excel"})
    @ResponseBody
    public void excel(HttpServletResponse response, PageQuery pageQuery) throws IOException {
        List data = this.all(pageQuery).getContent();
        ExcelUtils.export((HttpServletResponse)response, (List)data);
    }

    public TestClassController(TestClassService testClassService, TestClassRepo testClassRepo) {
        this.testClassService = testClassService;
        this.testClassRepo = testClassRepo;
    }
}

