/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.izouma.awesomeAdmin.domain.User;
import com.izouma.awesomeAdmin.dto.PageQuery;
import com.izouma.awesomeAdmin.dto.UserRegister;
import com.izouma.awesomeAdmin.enums.AuthorityName;
import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.repo.UserRepo;
import com.izouma.awesomeAdmin.security.Authority;
import com.izouma.awesomeAdmin.security.JwtTokenUtil;
import com.izouma.awesomeAdmin.security.JwtUserFactory;
import com.izouma.awesomeAdmin.service.UserService;
import com.izouma.awesomeAdmin.utils.ObjUtils;
import com.izouma.awesomeAdmin.utils.SecurityUtils;
import com.izouma.awesomeAdmin.utils.excel.ExcelUtils;
import com.izouma.awesomeAdmin.web.BaseController;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class UserController
extends BaseController {
    private UserRepo userRepo;
    private UserService userService;
    private JwtTokenUtil jwtTokenUtil;

    @PostMapping(value={"/register"})
    public User register(@RequestParam String username, @RequestParam String password) {
        UserRegister user = UserRegister.builder().username(username).nickname(username).password(new BCryptPasswordEncoder().encode((CharSequence)password)).authorities(Collections.singleton(Authority.get((AuthorityName)AuthorityName.ROLE_USER))).build();
        return this.userService.create(user);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/create"})
    public User create(@RequestBody UserRegister userRegister) {
        return this.userService.create(userRegister);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/save"})
    public User save(@RequestBody User user) {
        if (user.getId() != null) {
            User orig = (User)this.userRepo.findById((Object)user.getId()).orElseThrow(new BusinessException("\u65e0\u8bb0\u5f55"));
            ObjUtils.merge((Object)orig, (Object)user);
            return (User)this.userRepo.save((Object)orig);
        }
        return (User)this.userRepo.save((Object)user);
    }

    @GetMapping(value={"/my"})
    public User my() {
        return (User)this.userRepo.findById((Object)SecurityUtils.getAuthenticatedUser().getId()).orElseThrow(new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728"));
    }

    @GetMapping(value={"/myAdmin"})
    @PreAuthorize(value="hasRole('ADMIN')")
    public User myAdmin() {
        return (User)this.userRepo.findById((Object)SecurityUtils.getAuthenticatedUser().getId()).orElseThrow(new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728"));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/all"})
    public Page<User> all(@RequestBody PageQuery pageQuery) {
        return this.userService.all(pageQuery);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/get/{id}"})
    public User get(@PathVariable Long id) {
        return (User)this.userRepo.findById((Object)id).orElseThrow(new BusinessException("\u65e0\u8bb0\u5f55"));
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/del/{id}"})
    public void del(@PathVariable Long id) {
        this.userService.del(id);
    }

    @GetMapping(value={"/excel"})
    @ResponseBody
    public void excel(HttpServletResponse response, PageQuery pageQuery) throws IOException {
        List data = this.all(pageQuery).getContent();
        ExcelUtils.export((HttpServletResponse)response, (List)data);
    }

    @PostMapping(value={"/getMaUserInfo"})
    @ApiOperation(value="\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7528\u6237\u4fe1\u606f")
    public User getMaUserInfo(String sessionKey, String rawData, String signature, String encryptedData, String iv) {
        User user = this.userService.getMaUserInfo(sessionKey, rawData, signature, encryptedData, iv);
        if (user != null) {
            return user;
        }
        throw new BusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/setPasswordAdmin"})
    public String setPasswordAdmin(@RequestParam Long userId, @RequestParam String password) {
        return this.userService.setPassword(userId, password);
    }

    @PostMapping(value={"/changePassword"})
    public String changePassword(@RequestParam String password, @RequestParam String key, @RequestParam String code) {
        return this.userService.setPassword(SecurityUtils.getAuthenticatedUser().getId(), key, code, password);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/getToken/{userId}"})
    public String getToken(@PathVariable Long userId) {
        return this.jwtTokenUtil.generateToken((UserDetails)JwtUserFactory.create((User)((User)this.userRepo.findById((Object)userId).orElseThrow(new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728")))));
    }

    public UserController(UserRepo userRepo, UserService userService, JwtTokenUtil jwtTokenUtil) {
        this.userRepo = userRepo;
        this.userService = userService;
        this.jwtTokenUtil = jwtTokenUtil;
    }
}

