/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.config;

import com.izouma.awesomeAdmin.config.WxMpProperties;
import com.izouma.awesomeAdmin.mpHandler.LogHandler;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WxMpProperties.class})
public class WxMpConfiguration {
    private final WxMpProperties properties;
    private final LogHandler logHandler;

    @Bean
    public WxMpService wxMpService() {
        WxMpDefaultConfigImpl mpConfig = new WxMpDefaultConfigImpl();
        mpConfig.setAppId(this.properties.getAppId());
        mpConfig.setSecret(this.properties.getAppSecret());
        mpConfig.setAccessToken(this.properties.getToken());
        mpConfig.setAesKey(this.properties.getAesKey());
        WxMpServiceImpl service = new WxMpServiceImpl();
        service.setWxMpConfigStorage((WxMpConfigStorage)mpConfig);
        return service;
    }

    @Bean
    public WxMpMessageRouter messageRouter(WxMpService wxMpService) {
        WxMpMessageRouter newRouter = new WxMpMessageRouter(wxMpService);
        newRouter.rule().handler((WxMpMessageHandler)this.logHandler).next();
        return newRouter;
    }

    public WxMpConfiguration(WxMpProperties properties, LogHandler logHandler) {
        this.properties = properties;
        this.logHandler = logHandler;
    }
}

