/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import javax.persistence.AttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONObjectConverter
implements AttributeConverter<JSONObject, String> {
    private static final Logger log = LoggerFactory.getLogger(JSONObjectConverter.class);

    public String convertToDatabaseColumn(JSONObject jsonObject) {
        if (jsonObject != null) {
            return jsonObject.toJSONString();
        }
        return null;
    }

    public JSONObject convertToEntityAttribute(String s) {
        try {
            return JSON.parseObject((String)s);
        }
        catch (Exception e) {
            log.error("parse json error", (Throwable)e);
            return null;
        }
    }
}

