/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.domain;

import com.izouma.awesomeAdmin.annotations.Searchable;
import com.izouma.awesomeAdmin.domain.AuditedEntity;
import com.izouma.awesomeAdmin.domain.District;
import com.izouma.awesomeAdmin.enums.DistrictLevel;
import io.swagger.annotations.ApiModel;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Transient;

@Entity
@ApiModel(value="\u884c\u653f\u533a\u57df")
public class District
extends AuditedEntity {
    @Id
    private Long id;
    @Column(length=10)
    private String cityCode;
    @Searchable
    private String name;
    private double lat;
    private double lng;
    @Column(length=20)
    @Enumerated(value=EnumType.STRING)
    private DistrictLevel level;
    private Long parent;
    private int childCount;
    private int cityCount;
    private int districtCount;
    private int streetCount;
    @Transient
    private Boolean leaf;

    public static DistrictBuilder builder() {
        return new DistrictBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public String getName() {
        return this.name;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public DistrictLevel getLevel() {
        return this.level;
    }

    public Long getParent() {
        return this.parent;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public int getCityCount() {
        return this.cityCount;
    }

    public int getDistrictCount() {
        return this.districtCount;
    }

    public int getStreetCount() {
        return this.streetCount;
    }

    public Boolean getLeaf() {
        return this.leaf;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public void setLng(double lng) {
        this.lng = lng;
    }

    public void setLevel(DistrictLevel level) {
        this.level = level;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public void setChildCount(int childCount) {
        this.childCount = childCount;
    }

    public void setCityCount(int cityCount) {
        this.cityCount = cityCount;
    }

    public void setDistrictCount(int districtCount) {
        this.districtCount = districtCount;
    }

    public void setStreetCount(int streetCount) {
        this.streetCount = streetCount;
    }

    public void setLeaf(Boolean leaf) {
        this.leaf = leaf;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof District)) {
            return false;
        }
        District other = (District)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$cityCode = this.getCityCode();
        String other$cityCode = other.getCityCode();
        if (this$cityCode == null ? other$cityCode != null : !this$cityCode.equals(other$cityCode)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (Double.compare(this.getLat(), other.getLat()) != 0) {
            return false;
        }
        if (Double.compare(this.getLng(), other.getLng()) != 0) {
            return false;
        }
        DistrictLevel this$level = this.getLevel();
        DistrictLevel other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        Long this$parent = this.getParent();
        Long other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        if (this.getChildCount() != other.getChildCount()) {
            return false;
        }
        if (this.getCityCount() != other.getCityCount()) {
            return false;
        }
        if (this.getDistrictCount() != other.getDistrictCount()) {
            return false;
        }
        if (this.getStreetCount() != other.getStreetCount()) {
            return false;
        }
        Boolean this$leaf = this.getLeaf();
        Boolean other$leaf = other.getLeaf();
        return !(this$leaf == null ? other$leaf != null : !((Object)this$leaf).equals(other$leaf));
    }

    protected boolean canEqual(Object other) {
        return other instanceof District;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $cityCode = this.getCityCode();
        result = result * 59 + ($cityCode == null ? 43 : $cityCode.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $lat = Double.doubleToLongBits(this.getLat());
        result = result * 59 + (int)($lat >>> 32 ^ $lat);
        long $lng = Double.doubleToLongBits(this.getLng());
        result = result * 59 + (int)($lng >>> 32 ^ $lng);
        DistrictLevel $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        Long $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        result = result * 59 + this.getChildCount();
        result = result * 59 + this.getCityCount();
        result = result * 59 + this.getDistrictCount();
        result = result * 59 + this.getStreetCount();
        Boolean $leaf = this.getLeaf();
        result = result * 59 + ($leaf == null ? 43 : ((Object)$leaf).hashCode());
        return result;
    }

    public String toString() {
        return "District(id=" + this.getId() + ", cityCode=" + this.getCityCode() + ", name=" + this.getName() + ", lat=" + this.getLat() + ", lng=" + this.getLng() + ", level=" + this.getLevel() + ", parent=" + this.getParent() + ", childCount=" + this.getChildCount() + ", cityCount=" + this.getCityCount() + ", districtCount=" + this.getDistrictCount() + ", streetCount=" + this.getStreetCount() + ", leaf=" + this.getLeaf() + ")";
    }

    public District(Long id, String cityCode, String name, double lat, double lng, DistrictLevel level, Long parent, int childCount, int cityCount, int districtCount, int streetCount, Boolean leaf) {
        this.id = id;
        this.cityCode = cityCode;
        this.name = name;
        this.lat = lat;
        this.lng = lng;
        this.level = level;
        this.parent = parent;
        this.childCount = childCount;
        this.cityCount = cityCount;
        this.districtCount = districtCount;
        this.streetCount = streetCount;
        this.leaf = leaf;
    }

    public District() {
    }
}

