/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.exception;

import com.izouma.awesomeAdmin.exception.AuthenticationException;
import com.izouma.awesomeAdmin.exception.BusinessException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BusinessException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Map<String, Object> serviceExceptionHandler(BusinessException e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", e.getError());
        map.put("message", e.getMessage());
        map.put("code", -1);
        return map;
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public Map<String, Object> handleAuthenticationException(AuthenticationException e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", e.getMessage());
        map.put("code", -1);
        return map;
    }

    @ExceptionHandler(value={TransactionSystemException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Map<String, Object> serviceExceptionHandler(TransactionSystemException e) {
        String message = e.getMessage();
        try {
            if (e.getCause().getCause() instanceof ConstraintViolationException) {
                ConstraintViolationException violationException = (ConstraintViolationException)e.getCause().getCause();
                message = violationException.getConstraintViolations().stream().map(constraintViolation -> constraintViolation.getPropertyPath() + constraintViolation.getMessage()).collect(Collectors.joining(","));
                log.error(message);
            }
        }
        catch (Exception violationException) {
            // empty catch block
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", message);
        map.put("code", -1);
        return map;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Object serviceExceptionHandler(Exception e, HttpServletRequest request) {
        log.error(e.getMessage(), (Throwable)e);
        if (request.getHeader("Accept").contains("text/html")) {
            ModelAndView modelAndView = new ModelAndView("commons/500");
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            e.printStackTrace(writer);
            String trace = out.toString();
            trace = trace.replaceAll("\n", "<br>");
            modelAndView.addObject("trace", (Object)trace);
            return modelAndView;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", e.getMessage());
        map.put("code", -1);
        return map;
    }

    @ExceptionHandler(value={BindException.class, ConstraintViolationException.class, MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Map<String, Object> validateExceptionHandler(Exception e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\uff1a{}\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)request.getRequestURI(), (Object)e);
        StringBuilder sb = new StringBuilder("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a");
        HashMap<String, String> error = new HashMap<String, String>();
        String msg = "";
        if (!(e instanceof BindException) && !(e instanceof MethodArgumentNotValidException)) {
            for (ConstraintViolation cv : ((ConstraintViolationException)e).getConstraintViolations()) {
                msg = cv.getMessage();
                sb.append(msg).append("\uff1b");
                Iterator it = cv.getPropertyPath().iterator();
                Path.Node last = null;
                while (it.hasNext()) {
                    last = (Path.Node)it.next();
                }
                error.put(last != null ? last.getName() : "", msg);
            }
        } else {
            List allErrors = null;
            allErrors = e instanceof BindException ? ((BindException)e).getAllErrors() : ((MethodArgumentNotValidException)e).getBindingResult().getAllErrors();
            for (ObjectError oe : allErrors) {
                msg = oe.getDefaultMessage();
                sb.append(msg).append("\uff1b");
                if (oe instanceof FieldError) {
                    error.put(((FieldError)oe).getField(), msg);
                    continue;
                }
                error.put(oe.getObjectName(), msg);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", "\u53c2\u6570\u6821\u9a8c\u5931\u8d25");
        map.put("message", sb);
        map.put("code", -1);
        log.error(e.getMessage());
        return map;
    }
}

