/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.security;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.izouma.awesomeAdmin.enums.AuthorityName;
import com.izouma.awesomeAdmin.security.Authority;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true)
public class Authority
implements Serializable {
    @Id
    @Size(max=50)
    @NotNull
    @Column(length=50)
    private @Size(max=50) @NotNull String name;
    @Column(length=50)
    @Size(max=50)
    @NotNull
    private @Size(max=50) @NotNull String description;

    public static Authority get(AuthorityName name) {
        return new Authority(name.name(), name.getDescription());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authority authority = (Authority)o;
        return Objects.equals(this.name, authority.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "Authority{name='" + this.name + '\'' + "}";
    }

    public static AuthorityBuilder builder() {
        return new AuthorityBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Authority() {
    }

    public Authority(String name, String description) {
        this.name = name;
        this.description = description;
    }
}

