/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.security;

import com.izouma.awesomeAdmin.domain.User;
import com.izouma.awesomeAdmin.repo.UserRepo;
import com.izouma.awesomeAdmin.security.JwtUserFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="jwtUserDetailsService")
public class JwtUserDetailsService
implements UserDetailsService {
    private UserRepo userRepo;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.userRepo.findByUsernameAndDelFalse(username);
        if (user == null) {
            throw new UsernameNotFoundException(String.format("No user found with username '%s'.", username));
        }
        return JwtUserFactory.create((User)user);
    }

    public JwtUserDetailsService(UserRepo userRepo) {
        this.userRepo = userRepo;
    }
}

