/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.service;

import com.izouma.awesomeAdmin.domain.SysConfig;
import com.izouma.awesomeAdmin.dto.PageQuery;
import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.repo.SysConfigRepo;
import com.izouma.awesomeAdmin.utils.JpaUtils;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import springfox.documentation.annotations.Cacheable;

@Service
public class SysConfigService {
    private SysConfigRepo sysConfigRepo;

    public Page<SysConfig> all(PageQuery pageQuery) {
        return this.sysConfigRepo.findAll(JpaUtils.toSpecification((PageQuery)pageQuery, SysConfig.class), (Pageable)JpaUtils.toPageRequest((PageQuery)pageQuery));
    }

    @Cacheable(value="SysConfigServiceGetBigDecimal")
    public BigDecimal getBigDecimal(String name) {
        return this.sysConfigRepo.findByName(name).map(sysConfig -> new BigDecimal(sysConfig.getValue())).orElse(BigDecimal.ZERO);
    }

    @Cacheable(value="SysConfigServiceGetTime")
    public LocalTime getTime(String name) {
        String str = this.sysConfigRepo.findByName(name).map(SysConfig::getValue).orElseThrow(new BusinessException("\u914d\u7f6e\u4e0d\u5b58\u5728"));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        return LocalTime.from(dateTimeFormatter.parse(str));
    }

    @Cacheable(value="SysConfigServiceGetBoolean")
    public boolean getBoolean(String name) {
        String str = this.sysConfigRepo.findByName(name).map(SysConfig::getValue).orElseThrow(new BusinessException("\u914d\u7f6e\u4e0d\u5b58\u5728"));
        return str.equals("1");
    }

    @Cacheable(value="SysConfigServiceGetInt")
    public int getInt(String name) {
        String str = this.sysConfigRepo.findByName(name).map(SysConfig::getValue).orElseThrow(new BusinessException("\u914d\u7f6e\u4e0d\u5b58\u5728"));
        return Integer.parseInt(str);
    }

    public SysConfigService(SysConfigRepo sysConfigRepo) {
        this.sysConfigRepo = sysConfigRepo;
    }
}

