/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.izouma.awesomeAdmin.domain.User;
import com.izouma.awesomeAdmin.dto.PageQuery;
import com.izouma.awesomeAdmin.dto.UserRegister;
import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.repo.UserRepo;
import com.izouma.awesomeAdmin.security.Authority;
import com.izouma.awesomeAdmin.security.JwtTokenUtil;
import com.izouma.awesomeAdmin.security.JwtUserFactory;
import com.izouma.awesomeAdmin.service.CaptchaService;
import com.izouma.awesomeAdmin.service.sms.SmsService;
import com.izouma.awesomeAdmin.service.storage.StorageService;
import com.izouma.awesomeAdmin.utils.JpaUtils;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private UserRepo userRepo;
    private WxMaService wxMaService;
    private WxMpService wxMpService;
    private SmsService smsService;
    private StorageService storageService;
    private JwtTokenUtil jwtTokenUtil;
    private CaptchaService captchaService;

    public Page<User> all(PageQuery pageQuery) {
        return this.userRepo.findAll(JpaUtils.toSpecification((PageQuery)pageQuery, User.class), (Pageable)JpaUtils.toPageRequest((PageQuery)pageQuery));
    }

    public User create(UserRegister userRegister) {
        User user = new User();
        BeanUtils.copyProperties((Object)userRegister, (Object)user);
        if (StringUtils.isNotBlank((CharSequence)userRegister.getPassword())) {
            user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)userRegister.getPassword()));
        }
        return (User)this.userRepo.save((Object)user);
    }

    public void del(Long id) {
        User user = (User)this.userRepo.findById((Object)id).orElseThrow(new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728"));
        user.setDel(true);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{user.getOpenId()})) {
            user.setOpenId(user.getOpenId() + "###" + RandomStringUtils.randomAlphabetic((int)8));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{user.getPhone()})) {
            user.setPhone(user.getPhone() + "###" + RandomStringUtils.randomAlphabetic((int)8));
        }
        this.userRepo.save((Object)user);
    }

    public User loginByPhone(String phone) {
        return this.userRepo.findByPhoneAndDelFalse(phone);
    }

    public User loginMp(String code) throws WxErrorException {
        WxMpOAuth2AccessToken accessToken = this.wxMpService.oauth2getAccessToken(code);
        WxMpUser wxMpUser = this.wxMpService.oauth2getUserInfo(accessToken, null);
        User user = this.userRepo.findByOpenIdAndDelFalse(wxMpUser.getOpenId());
        if (user == null) {
            user = User.builder().username(UUID.randomUUID().toString()).nickname(wxMpUser.getNickname()).avatar(wxMpUser.getHeadImgUrl()).sex(wxMpUser.getSexDesc()).country(wxMpUser.getCountry()).province(wxMpUser.getProvince()).city(wxMpUser.getCity()).openId(wxMpUser.getOpenId()).language(wxMpUser.getLanguage()).authorities(Collections.singleton(Authority.builder().name("ROLE_USER").build())).build();
            this.userRepo.save((Object)user);
        }
        return user;
    }

    public User loginMa(String code) {
        try {
            WxMaJscode2SessionResult result = this.wxMaService.jsCode2SessionInfo(code);
            String openId = result.getOpenid();
            String sessionKey = result.getSessionKey();
            User userInfo = this.userRepo.findByOpenIdAndDelFalse(openId);
            if (userInfo != null) {
                return userInfo;
            }
            userInfo = User.builder().username(UUID.randomUUID().toString()).nickname("\u7528\u6237" + RandomStringUtils.randomAlphabetic((int)6)).openId(openId).avatar("https://zhumj.oss-cn-hangzhou.aliyuncs.com/image/user.jpg").authorities(Collections.singleton(Authority.builder().name("ROLE_USER").build())).build();
            userInfo = (User)this.userRepo.save((Object)userInfo);
            return userInfo;
        }
        catch (WxErrorException e) {
            e.printStackTrace();
            throw new BusinessException("\u767b\u5f55\u5931\u8d25");
        }
    }

    public User getMaUserInfo(String sessionKey, String rawData, String signature, String encryptedData, String iv) {
        if (!this.wxMaService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        WxMaUserInfo wxUserInfo = this.wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, iv);
        User user = this.userRepo.findByOpenIdAndDelFalse(wxUserInfo.getOpenId());
        String avatarUrl = "https://zhumj.oss-cn-hangzhou.aliyuncs.com/image/user.jpg";
        try {
            String path = "image/avatar/" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()) + RandomStringUtils.randomAlphabetic((int)8) + ".jpg";
            avatarUrl = this.storageService.uploadFromUrl(wxUserInfo.getAvatarUrl(), path);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5934\u50cf\u5931\u8d25", (Throwable)e);
        }
        if (user == null) {
            user = User.builder().username(UUID.randomUUID().toString()).nickname(wxUserInfo.getNickName()).openId(wxUserInfo.getOpenId()).avatar(avatarUrl).sex(wxUserInfo.getGender()).country(wxUserInfo.getCountry()).province(wxUserInfo.getProvince()).city(wxUserInfo.getCity()).authorities(Collections.singleton(Authority.builder().name("ROLE_USER").build())).build();
            user = (User)this.userRepo.save((Object)user);
        } else {
            user.setAvatar(avatarUrl);
            user.setNickname(wxUserInfo.getNickName());
            user.setSex(wxUserInfo.getGender());
            user.setCountry(wxUserInfo.getCountry());
            user.setProvince(wxUserInfo.getProvince());
            user.setCity(wxUserInfo.getCity());
            user = (User)this.userRepo.save((Object)user);
        }
        return user;
    }

    public String setPassword(Long userId, String password) {
        User user = (User)this.userRepo.findById((Object)userId).orElseThrow(new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728"));
        user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)password));
        user = (User)this.userRepo.save((Object)user);
        return this.jwtTokenUtil.generateToken((UserDetails)JwtUserFactory.create((User)user));
    }

    public String setPassword(Long userId, String key, String code, String password) {
        if (!this.captchaService.verify(key, code)) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return this.setPassword(userId, password);
    }

    public UserService(UserRepo userRepo, WxMaService wxMaService, WxMpService wxMpService, SmsService smsService, StorageService storageService, JwtTokenUtil jwtTokenUtil, CaptchaService captchaService) {
        this.userRepo = userRepo;
        this.wxMaService = wxMaService;
        this.wxMpService = wxMpService;
        this.smsService = smsService;
        this.storageService = storageService;
        this.jwtTokenUtil = jwtTokenUtil;
        this.captchaService = captchaService;
    }
}

