/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.service.sms;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.izouma.awesomeAdmin.domain.SmsRecord;
import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.repo.SmsRecordRepo;
import com.izouma.awesomeAdmin.service.sms.SmsService;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class AliSmsService
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(AliSmsService.class);
    @Value(value="${aliyun.access-key-id}")
    private String accessKeyId;
    @Value(value="${aliyun.access-key-secret}")
    private String accessKeySecret;
    @Autowired
    private SmsRecordRepo smsRecordRepo;

    public String sendVerify(String phone) {
        this.smsRecordRepo.findLastByPhoneAndExpiresAtAfterAndExpiredFalse(phone, LocalDateTime.now()).ifPresent(record -> {
            if (record.getCreatedAt().plusMinutes(1L).isAfter(LocalDateTime.now())) {
                long sec = record.getCreatedAt().plusMinutes(1L).toInstant(ZoneOffset.UTC).getEpochSecond() - LocalDateTime.now().toInstant(ZoneOffset.UTC).getEpochSecond() + 1L;
                throw new BusinessException("\u8bf7" + sec + "\u79d2\u540e\u518d\u8bd5");
            }
        });
        String code = RandomStringUtils.randomNumeric((int)4);
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.accessKeyId, (String)this.accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("PhoneNumbers", phone);
        request.putQueryParameter("SignName", "\u8d70\u9a6c\u4fe1\u606f");
        request.putQueryParameter("TemplateCode", "SMS_175485688");
        request.putQueryParameter("TemplateParam", "{\"code\":\"" + code + "\"}");
        try {
            CommonResponse response = client.getCommonResponse(request);
            if (response.getHttpStatus() != 200) {
                throw new BusinessException("\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", response.getHttpStatus() + "," + response.getData());
            }
            log.info("send sms response {}", (Object)response.getData());
            JSONObject jsonObject = new JSONObject(response.getData());
            if (!"ok".equalsIgnoreCase(jsonObject.getString("Code"))) {
                throw new BusinessException("\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", jsonObject.getString("Message"));
            }
            this.smsRecordRepo.expire(phone);
            String sessionId = RandomStringUtils.randomAlphabetic((int)10);
            this.smsRecordRepo.save((Object)SmsRecord.builder().sessionId(sessionId).phone(phone).code(code).expiresAt(LocalDateTime.now().plusMinutes(5L)).expired(Boolean.valueOf(false)).build());
            return sessionId;
        }
        catch (ClientException | JSONException e) {
            e.printStackTrace();
            throw new BusinessException("\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", e.getMessage());
        }
    }

    public void verify(String phone, String code) throws SmsService.SmsVerifyException {
        SmsRecord smsRecord = (SmsRecord)this.smsRecordRepo.findLastByPhoneAndExpiresAtAfterAndExpiredFalse(phone, LocalDateTime.now()).orElseThrow(new SmsService.SmsVerifyException("\u9a8c\u8bc1\u7801\u9519\u8bef"));
        if (!smsRecord.getCode().equalsIgnoreCase(code)) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        smsRecord.setExpired(Boolean.valueOf(true));
        this.smsRecordRepo.save((Object)smsRecord);
    }
}

