/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.service.storage;

import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.service.storage.StorageService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"storage.provider"}, havingValue="local")
public class LocalStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageService.class);
    @Value(value="${storage.local_path}")
    private String localPath;

    public String uploadFromInputStream(InputStream fin, String path) {
        log.info("\u672c\u5730\u4e0a\u4f20: inputStream -> {}", (Object)path);
        try {
            return this.upload(fin, path);
        }
        catch (IOException e) {
            log.error("\u672c\u5730\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25", e.getMessage());
        }
    }

    public String uploadFromUrl(String url, String path) {
        log.info("\u672c\u5730\u4e0a\u4f20: {} -> {}", (Object)url, (Object)path);
        try {
            InputStream inputStream = new URL(url).openStream();
            return this.upload(inputStream, path);
        }
        catch (Exception e) {
            log.error("\u672c\u5730\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25", e.getMessage());
        }
    }

    private String upload(InputStream inputStream, String path) throws IOException {
        Path uploadPath = Paths.get(this.localPath, path).getParent();
        if (Files.notExists(uploadPath, LinkOption.values())) {
            Files.createDirectories(uploadPath, new FileAttribute[0]);
        }
        FileUtils.copyToFile((InputStream)inputStream, (File)new File(Paths.get(this.localPath, path).toString()));
        try {
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "files/" + path;
    }
}

