/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.service.storage.StorageService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/upload"})
public class FileUploadController {
    private static final Logger log = LoggerFactory.getLogger(FileUploadController.class);
    @Autowired
    private StorageService storageService;

    @PostMapping(value={"/file"})
    public String uploadFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="   ", required=false) String path) {
        InputStream is;
        if (path == null) {
            String basePath = "application";
            try {
                basePath = file.getContentType().split("/")[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
            path = basePath + "/" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()) + RandomStringUtils.randomAlphabetic((int)8) + "." + FilenameUtils.getExtension((String)file.getOriginalFilename());
        }
        try {
            is = file.getInputStream();
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25", e.getMessage());
        }
        return this.storageService.uploadFromInputStream(is, path);
    }

    @PostMapping(value={"/base64"})
    public String uploadImage(@RequestParam(value="base64") String base64, @RequestParam(value="path", required=false) String path) {
        ByteArrayInputStream is;
        base64 = base64.substring(base64.indexOf(44) + 1);
        Base64.Decoder decoder = Base64.getDecoder();
        if (path == null) {
            String ext = ".jpg";
            try {
                ByteArrayInputStream is2 = new ByteArrayInputStream(decoder.decode(base64.getBytes()));
                String type = URLConnection.guessContentTypeFromStream(is2);
                ext = type.replace("image/", ".").replace("jpeg", "jpg");
            }
            catch (Exception is2) {
                // empty catch block
            }
            path = "image/" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()) + RandomStringUtils.randomAlphabetic((int)8) + ext;
        }
        try {
            is = new ByteArrayInputStream(decoder.decode(base64.getBytes()));
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25", e.getMessage());
        }
        return this.storageService.uploadFromInputStream((InputStream)is, path);
    }
}

