/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.izouma.awesomeAdmin.dto.gen.GenCode;
import com.izouma.awesomeAdmin.dto.gen.TableField;
import com.izouma.awesomeAdmin.service.GenCodeService;
import com.izouma.awesomeAdmin.utils.JsonUtils;
import com.izouma.awesomeAdmin.utils.PinYinUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.CaseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/genCode"})
public class GenCodeController {
    @Autowired
    private GenCodeService genCodeService;

    @GetMapping(value={"/all"})
    public List<GenCode> all(GenCode record) throws IOException {
        BufferedReader reader = null;
        ArrayList<GenCode> genCodeList = new ArrayList<GenCode>();
        String genJsonPath = Paths.get(System.getProperty("user.dir"), "src", "main", "resources", "genjson").toString();
        File file = new File(genJsonPath);
        File[] fs = file.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (f.isDirectory()) continue;
                System.out.println(f);
                reader = new BufferedReader(new FileReader(f));
                Gson gson = new GsonBuilder().create();
                GenCode genCode = (GenCode)gson.fromJson((Reader)reader, GenCode.class);
                genCodeList.add(genCode);
                reader.close();
            }
        }
        return genCodeList;
    }

    @GetMapping(value={"/getOne"})
    public GenCode getGenCode(@RequestParam String className) throws IOException {
        File file = new File(Paths.get(System.getProperty("user.dir"), "src", "main", "resources", "genjson", className + ".json").toString());
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Gson gson = new Gson();
        GenCode genCode = (GenCode)gson.fromJson((Reader)reader, GenCode.class);
        reader.close();
        return genCode;
    }

    @PostMapping(value={"/save"})
    public GenCode save(@RequestBody GenCode record) {
        try {
            String basePackage = this.getClass().getPackage().getName().replace(".web", "");
            record.setBasePackage(basePackage);
            String genPackage = record.getTablePackage().replace(basePackage + ".domain.", "").replace("." + record.getTableName(), "");
            if (!genPackage.startsWith(record.getTableName())) {
                record.setGenPackage(genPackage);
            } else {
                record.setGenPackage(null);
            }
            Gson gson = new Gson();
            String genCodeStr = gson.toJson((Object)record);
            String resourcesPath = record.getResourcesPath();
            String genCodeName = record.getClassName() + ".json";
            this.genCode(record);
            try {
                File dir = new File(resourcesPath + "/genjson/");
                dir.mkdirs();
                File file = new File(resourcesPath + "/genjson/" + genCodeName);
                file.createNewFile();
                BufferedWriter output = new BufferedWriter(new FileWriter(file));
                output.write(genCodeStr);
                output.close();
            }
            catch (Exception e) {
                System.err.println("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff01");
                e.printStackTrace();
            }
            return record;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void genCode(@RequestBody GenCode record) throws Exception {
        String tableName = record.getTableName();
        if (PinYinUtil.isContainChinese((String)tableName)) {
            tableName = PinYinUtil.getStringPinYin((String)tableName);
        }
        if (StringUtils.isEmpty((String)record.getClassName())) {
            record.setClassName(CaseUtils.toCamelCase((String)tableName, (boolean)true, (char[])new char[]{'_'}));
        }
        if (Pattern.matches(".*[ _\\-].*", record.getClassName())) {
            record.setClassName(CaseUtils.toCamelCase((String)tableName, (boolean)true, (char[])new char[]{'_', ' ', '-'}));
        }
        record.setClassName(StringUtils.capitalize((String)record.getClassName()));
        if (record.getGenClass().booleanValue()) {
            this.genCodeService.genController(record);
            this.genCodeService.genService(record);
            this.genCodeService.genRepo(record);
        }
        if (record.getGenList().booleanValue()) {
            this.genCodeService.genListView(record);
        }
        if (record.getGenForm().booleanValue()) {
            this.genCodeService.genEditView(record);
        }
        if (record.getGenRouter().booleanValue()) {
            this.genCodeService.genRouter(record);
        }
        Process process = new ProcessBuilder(new String[0]).command("npm", "run", "lint").directory(Paths.get(record.getRouterPath(), new String[0]).getParent().toFile()).start();
        process.waitFor();
    }

    @GetMapping(value={"/getSrcPath"})
    public Map<String, Object> getSrcPath() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> javaPath = new ArrayList<String>(Arrays.asList("src", "main", "java"));
        javaPath.addAll(Arrays.asList(this.getClass().getPackage().getName().split("\\.")));
        map.put("javaPath", Paths.get(System.getProperty("user.dir"), javaPath.toArray(new String[0])).getParent().toString());
        map.put("viewPath", Paths.get(System.getProperty("user.dir"), "src", "main", "vue", "src", "views").toString());
        map.put("routerPath", Paths.get(System.getProperty("user.dir"), "src", "main", "vue", "src").toString());
        map.put("resourcesPath", Paths.get(System.getProperty("user.dir"), "src", "main", "resources").toString());
        return map;
    }

    @GetMapping(value={"/tableFields"})
    public List<TableField> tableFields(@RequestParam String className) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<TableField> tableFieldList = new ArrayList<TableField>();
        for (Field declaredField : Class.forName(className).getDeclaredFields()) {
            JsonIgnore jsonIgnore = declaredField.getDeclaredAnnotation(JsonIgnore.class);
            if (jsonIgnore != null) continue;
            TableField tableField = new TableField();
            tableField.setName(declaredField.getName());
            tableField.setModelName(declaredField.getName());
            tableField.setRemark(declaredField.getName());
            tableField.setShowInList(Boolean.valueOf(true));
            tableField.setShowInForm(Boolean.valueOf(true));
            if (declaredField.getType().isEnum()) {
                tableField.setFormType("select");
                tableField.setApiFlag("1");
                String builder = new JsonUtils.ArrayBuilder();
                for (Object enumConstant : declaredField.getType().getEnumConstants()) {
                    String name;
                    String desc = name = (String)enumConstant.getClass().getMethod("name", new Class[0]).invoke(enumConstant, new Object[0]);
                    try {
                        desc = (String)enumConstant.getClass().getMethod("getDescription", new Class[0]).invoke(enumConstant, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("label", desc);
                    map.put("value", name);
                    builder.add(map);
                }
                tableField.setOptionsValue(builder.build());
            } else {
                switch (declaredField.getType().getName()) {
                    case "java.lang.Boolean": {
                        tableField.setFormType("switch");
                        break;
                    }
                    case "java.lang.Integer": 
                    case "java.lang.Long": 
                    case "java.lang.Double": 
                    case "java.lang.Float": 
                    case "java.math.BigDecimal": {
                        tableField.setFormType("number");
                        break;
                    }
                    case "java.time.LocalDateTime": 
                    case "java.util.Date": {
                        tableField.setFormType("datetime");
                        break;
                    }
                    case "java.time.LocalDate": {
                        tableField.setFormType("date");
                        break;
                    }
                    default: {
                        tableField.setFormType("singleLineText");
                    }
                }
            }
            ApiModelProperty apiModelProperty = declaredField.getDeclaredAnnotation(ApiModelProperty.class);
            if (apiModelProperty != null) {
                tableField.setRemark(apiModelProperty.value());
            }
            tableFieldList.add(tableField);
        }
        return tableFieldList;
    }
}

