/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.izouma.awesomeAdmin.domain.SysConfig;
import com.izouma.awesomeAdmin.dto.PageQuery;
import com.izouma.awesomeAdmin.exception.BusinessException;
import com.izouma.awesomeAdmin.repo.SysConfigRepo;
import com.izouma.awesomeAdmin.service.SysConfigService;
import com.izouma.awesomeAdmin.utils.excel.ExcelUtils;
import com.izouma.awesomeAdmin.web.BaseController;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysConfig"})
public class SysConfigController
extends BaseController {
    private SysConfigService sysConfigService;
    private SysConfigRepo sysConfigRepo;

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/save"})
    @CacheEvict(value={"SysConfigServiceGetBigDecimal", "SysConfigServiceGetTime", "SysConfigServiceGetBoolean", "SysConfigServiceGetInt"}, allEntries=true)
    public SysConfig save(@RequestBody SysConfig record) {
        return (SysConfig)this.sysConfigRepo.save((Object)record);
    }

    @PostMapping(value={"/all"})
    public Page<SysConfig> all(@RequestBody PageQuery pageQuery) {
        return this.sysConfigService.all(pageQuery);
    }

    @GetMapping(value={"/get/{id}"})
    public SysConfig get(@PathVariable String id) {
        return (SysConfig)this.sysConfigRepo.findByName(id).orElseThrow(new BusinessException("\u65e0\u8bb0\u5f55"));
    }

    @PostMapping(value={"/del/{id}"})
    public void del(@PathVariable String id) {
        this.sysConfigRepo.deleteById((Object)id);
    }

    @GetMapping(value={"/excel"})
    @ResponseBody
    public void excel(HttpServletResponse response, PageQuery pageQuery) throws IOException {
        List data = this.all(pageQuery).getContent();
        ExcelUtils.export((HttpServletResponse)response, (List)data);
    }

    public SysConfigController(SysConfigService sysConfigService, SysConfigRepo sysConfigRepo) {
        this.sysConfigService = sysConfigService;
        this.sysConfigRepo = sysConfigRepo;
    }
}

