/*
 * Decompiled with CFR 0.152.
 */
package com.izouma.awesomeAdmin.web;

import com.alibaba.fastjson.JSONObject;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.izouma.awesomeAdmin.exception.BusinessException;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/wx"})
public class WxController {
    private static final Logger log = LoggerFactory.getLogger(WxController.class);
    private WxMpService wxMpService;
    private WxPayService wxPayService;
    private Environment env;

    @RequestMapping(value={"/testMp"})
    public ModelAndView testPay(@RequestParam(required=false) String code, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            WxMpOAuth2AccessToken accessToken = this.wxMpService.oauth2getAccessToken(code);
            WxMpUser wxMpUser = this.wxMpService.oauth2getUserInfo(accessToken, null);
            ModelAndView mav = new ModelAndView("WxMpTest");
            mav.addObject("user", (Object)wxMpUser);
            return mav;
        }
        catch (WxErrorException e) {
            String url = this.wxMpService.oauth2buildAuthorizationUrl(this.env.getProperty("general.host") + request.getServletPath(), "snsapi_userinfo", null);
            log.info("\u5fae\u4fe1\u91cd\u5b9a\u5411: {}", (Object)url);
            response.sendRedirect(url);
            ModelAndView mav = new ModelAndView("Error");
            mav.addObject("title", (Object)"redirect");
            mav.addObject("body", (Object)"redirect");
            return mav;
        }
    }

    @GetMapping(value={"/testPay"})
    public WxPayMpOrderResult testPayApi(@RequestParam String openId, @RequestParam Integer totalFee) {
        WxPayUnifiedOrderRequest request = new WxPayUnifiedOrderRequest();
        request.setBody("\u6d4b\u8bd5\u5fae\u4fe1\u652f\u4ed8");
        request.setDetail("\u6d4b\u8bd5\u5fae\u4fe1\u652f\u4ed8");
        request.setOutTradeNo(RandomStringUtils.randomAlphanumeric((int)32));
        request.setTotalFee(totalFee);
        request.setSpbillCreateIp("180.102.110.170");
        request.setNotifyUrl(this.env.getProperty("wx.pay.notifyUrl"));
        request.setTradeType("JSAPI");
        request.setOpenid(openId);
        request.setSignType("MD5");
        try {
            return (WxPayMpOrderResult)this.wxPayService.createOrder(request);
        }
        catch (WxPayException e) {
            log.error("unifiedOrder error", (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    @GetMapping(value={"/greet"})
    public String greetUser(@RequestParam String code) {
        try {
            WxMpOAuth2AccessToken accessToken = this.wxMpService.oauth2getAccessToken(code);
            WxMpUser user = this.wxMpService.oauth2getUserInfo(accessToken, null);
            return user.getNickname();
        }
        catch (WxErrorException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @GetMapping(value={"/getCode"})
    public String getCode(@RequestParam String code) {
        return code;
    }

    @GetMapping(value={"/redirect"})
    public void redirect(HttpServletResponse response, @RequestParam String redirectUrl) throws IOException {
        String url = this.wxMpService.oauth2buildAuthorizationUrl(redirectUrl, "snsapi_userinfo", null);
        log.info("\u5fae\u4fe1\u91cd\u5b9a\u5411: {}", (Object)url);
        response.sendRedirect(url);
    }

    @PostMapping(value={"/payNotify"}, produces={"application/xml"})
    public String wxNotify(@RequestBody String xmlData) throws WxPayException {
        log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03: {}", (Object)xmlData);
        WxPayOrderNotifyResult notifyResult = this.wxPayService.parseOrderNotifyResult(xmlData);
        notifyResult.checkResult(this.wxPayService, "MD5", true);
        JSONObject attach = JSONObject.parseObject((String)notifyResult.getAttach());
        String type = attach.getString("type");
        type.getClass();
        return WxPayNotifyResponse.success((String)"OK");
    }

    @PostMapping(value={"/refundNotify"}, produces={"application/xml"})
    public String refundNotify(@RequestBody String xmlData) throws WxPayException {
        log.info("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03: {}", (Object)xmlData);
        WxPayRefundNotifyResult notifyResult = this.wxPayService.parseRefundNotifyResult(xmlData);
        notifyResult.checkResult(this.wxPayService, "MD5", true);
        return WxPayNotifyResponse.success((String)"OK");
    }

    @GetMapping(value={"/jsapiSign"})
    @ApiOperation(value="jsapi\u7b7e\u540d")
    public WxJsapiSignature sign(@RequestParam String url) throws WxErrorException {
        return this.wxMpService.createJsapiSignature(url);
    }

    public WxController(WxMpService wxMpService, WxPayService wxPayService, Environment env) {
        this.wxMpService = wxMpService;
        this.wxPayService = wxPayService;
        this.env = env;
    }
}

