package ${model.basePackage}.web<#if model.genPackage??>.${model.genPackage}</#if>;
<#if imports??>

<#list imports as i>
${i}
</#list>
</#if>
import ${model.basePackage}.domain.<#if model.genPackage??>${model.genPackage}.</#if>${model.className};
import ${model.basePackage}.service.<#if model.genPackage??>${model.genPackage}.</#if>${model.className}Service;
import ${model.basePackage}.dto.PageQuery;
import ${model.basePackage}.exception.BusinessException;
import ${model.basePackage}.repo.<#if model.genPackage??>${model.genPackage}.</#if>${model.className}Repo;
import ${model.basePackage}.utils.ObjUtils;
import ${model.basePackage}.utils.excel.ExcelUtils;
<#if subPackage == true>

</#if>
import lombok.AllArgsConstructor;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

@RestController
@RequestMapping("/${model.className?uncap_first}")
@AllArgsConstructor
public class ${model.className}Controller extends BaseController {
    private ${model.className}Service ${model.className?uncap_first}Service;
    private ${model.className}Repo ${model.className?uncap_first}Repo;

    //@PreAuthorize("hasRole('ADMIN')")
    @PostMapping("/save")
    public ${model.className} save(@RequestBody ${model.className} record) {
        if (record.getId() != null) {
            ${model.className} orig = ${model.className?uncap_first}Repo.findById(record.getId()).orElseThrow(new BusinessException("无记录"));
            ObjUtils.merge(orig, record);
            return ${model.className?uncap_first}Repo.save(orig);
        }
        return ${model.className?uncap_first}Repo.save(record);
    }


    //@PreAuthorize("hasRole('ADMIN')")
    @PostMapping("/all")
    public Page<${model.className}> all(@RequestBody PageQuery pageQuery) {
        return ${model.className?uncap_first}Service.all(pageQuery);
    }

    @GetMapping("/get/{id}")
    public ${model.className} get(@PathVariable Long id) {
        return ${model.className?uncap_first}Repo.findById(id).orElseThrow(new BusinessException("无记录"));
    }

    @PostMapping("/del/{id}")
    public void del(@PathVariable Long id) {
<#if softDelete == true>
        ${model.className?uncap_first}Repo.softDelete(id);
<#else>
        ${model.className?uncap_first}Repo.deleteById(id);
</#if>
    }

    @GetMapping("/excel")
    @ResponseBody
    public void excel(HttpServletResponse response, PageQuery pageQuery) throws IOException {
        List<${model.className}> data = all(pageQuery).getContent();
        ExcelUtils.export(response, data);
    }
}

