<template>
    <div  class="list-view">
        <page-title>
            <el-button @click="addRow" type="primary" icon="el-icon-plus" :loading="downloading" class="filter-item">
                新增
            </el-button>
            <el-button @click="download" icon="el-icon-upload2" :loading="downloading" class="filter-item">
                导出
            </el-button>
        </page-title>
        <div class="filters-container">
            <el-input
                    placeholder="搜索..."
                    v-model="search"
                    clearable
                    class="filter-item search"
                    @keyup.enter.native="getData"
            >
                <el-button @click="getData" slot="append" icon="el-icon-search"> </el-button>
            </el-input>
        </div>
        <el-table :data="tableData" row-key="id" ref="table"
                  header-row-class-name="table-header-row"
                  header-cell-class-name="table-header-cell"
                  row-class-name="table-row" cell-class-name="table-cell"
                  :height="tableHeight">
            <el-table-column v-if="multipleMode" align="center" type="selection"
                             width="50">
            </el-table-column>
            <el-table-column prop="id" label="ID" width="100">
            </el-table-column>
            <#list model.fields as field>
                <#if field.showInList>
                    <el-table-column prop="${field.modelName!''}" label="${field.remark!field.modelName}"
                        <#if field.formType == 'select' && field.apiFlag == '1'>
                            :formatter="${field.modelName}Formatter"
                        </#if>>
                        <#if field.sortable!false>
                            <template slot="header" slot-scope="{column}">
                                <sortable-header :column="column" :current-sort="sort" @changeSort="changeSort">
                                </sortable-header>
                            </template>
                        </#if>
                        <#if field.formType == 'singleImage'>
                            <template slot-scope="{row}">
                                <el-image style="width: 30px; height: 30px"
                                          :src="row.${field.modelName}" fit="cover"
                                          :preview-src-list="[row.${field.modelName}]"></el-image>
                            </template>
                        <#elseif field.formType == 'multiImage'>
                            <template slot-scope="{row}">
                                <el-image style="width: 30px; height: 30px"
                                          :src="row.${field.modelName}[0]" fit="cover"
                                          :preview-src-list="row.${field.modelName}"></el-image>
                            </template>
                        <#elseif field.formType == 'switch'>
                            <template slot-scope="{row}">
                                <el-tag :type="row.${field.modelName}?'':'info'">{{row.${field.modelName}}}</el-tag>
                            </template>
                        </#if>
                    </el-table-column>
                </#if>
            </#list>
            <el-table-column
                    label="操作"
                    align="center"
                    fixed="right"
                    min-width="150">
                <template slot-scope="{row}">
                    <#list model.subtables as subtable>
                        <el-button @click="$router.push({path:'/${subtable.subCode}List',query:{column:row.${subtable.column}+',${subtable.subColumn}'}})" type="primary" size="small" plain>${subtable.name}
                        </el-button>
                    </#list>
                    <el-button @click="editRow(row)" type="primary" size="mini" plain>编辑</el-button>
                    <el-button @click="deleteRow(row)" type="danger" size="mini" plain>删除</el-button>
                </template>
            </el-table-column>
        </el-table>
        <div class="pagination-wrapper">
            <!-- <div class="multiple-mode-wrapper">
                <el-button v-if="!multipleMode" @click="toggleMultipleMode(true)">批量编辑</el-button>
                <el-button-group v-else>
                    <el-button @click="operation1">批量操作1</el-button>
                    <el-button @click="operation2">批量操作2</el-button>
                    <el-button @click="toggleMultipleMode(false)">取消</el-button>
                </el-button-group>
            </div> -->
            <el-pagination background @size-change="onSizeChange"
                           @current-change="onCurrentChange" :current-page="page"
                           :page-sizes="[10, 20, 30, 40, 50]" :page-size="pageSize"
                           layout="total, sizes, prev, pager, next, jumper"
                           :total="totalElements">
            </el-pagination>
        </div>

    </div>
</template>
<script>
    import { mapState } from "vuex";
    import pageableTable from "@/mixins/pageableTable";

    export default {
        name: '${model.className}List',
        mixins: [pageableTable],
        data() {
            return {
                multipleMode: false,
                search: "",
                url: "/${model.className?uncap_first}/all",
                downloading: false,
                <#list model.fields as field>
                    <#if field.formType == 'select' && field.apiFlag == '1'>
                        ${field.modelName}Options:${field.optionsValue},
                    </#if>
                </#list>
            }
        },
        computed: {
            selection() {
                return this.$refs.table.selection.map(i => i.id);
            }
        },
        methods: {
            <#list model.fields as field>
                <#if field.formType == 'select' && field.apiFlag == '1'>
                    ${field.modelName}Formatter(row, column, cellValue, index) {
                        let selectedOption = this.${field.modelName}Options.find(i => i.value === cellValue);
                        if (selectedOption) {
                            return selectedOption.label;
                        }
                        return '';
                    },
                </#if>
            </#list>
            beforeGetData() {
                return { search: this.search };
            },
            toggleMultipleMode(multipleMode) {
                this.multipleMode = multipleMode;
                if (!multipleMode) {
                    this.$refs.table.clearSelection();
                }
            },
            addRow() {
                this.$router.push({
                    path: "/${model.className?uncap_first}Edit",
                    query: {
                        ...this.$route.query
                    }
                });
            },
            editRow(row) {
                this.$router.push({
                    path: "/${model.className?uncap_first}Edit",
                    query: {
                    id: row.id
                    }
                });
            },
            download() {
                this.downloading = true;
                this.$axios
                    .get("/${model.className?uncap_first}/excel", { 
                        responseType: "blob",
                        params: { size: 10000 }
                    })
                    .then(res => {
                        console.log(res);
                        this.downloading = false;
                        const downloadUrl = window.URL.createObjectURL(new Blob([res.data]));
                        const link = document.createElement("a");
                        link.href = downloadUrl;
                        link.setAttribute(
                            "download",
                            res.headers["content-disposition"].split("filename=")[1]
                        );
                        document.body.appendChild(link);
                        link.click();
                        link.remove();
                    })
                    .catch(e => {
                        console.log(e);
                        this.downloading = false;
                        this.$message.error(e.error);
                    });
            },
            operation1() {
                this.$notify({
                    title: '提示',
                    message: this.selection
                });
            },
            operation2() {
                this.$message('操作2');
            },
            deleteRow(row) {
                this.$alert('删除将无法恢复，确认要删除么？', '警告', {type: 'error'}).then(() => {
                    return this.$http.post(`/${model.className?uncap_first}/del/${r'${row.id}'}`)
                }).then(() => {
                    this.$message.success('删除成功');
                    this.getData();
                }).catch(e => {
                    if (e !== 'cancel') {
                        this.$message.error(e.error);
                    }
                })
            },
        }
    }
</script>
<style lang="less" scoped>
</style>
