<!DOCTYPE html>
<html lang="zh-cmn-Hans">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scaleable=no">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" type="text/css" href="https://res.wx.qq.com/open/libs/weui/2.1.4/weui.min.css"/>
    <script type="text/javascript" src="http://res.wx.qq.com/open/js/jweixin-1.6.0.js"></script>
    <script src="https://cdn.bootcss.com/vConsole/3.3.4/vconsole.min.js"></script>
    <script src="https://cdn.bootcss.com/jquery/3.4.1/jquery.min.js"></script>
    <title>微信测试页面</title>
    <style>
        body {
            margin: 0;
            background-color: #ededed;
        }

        .page__hd {
            padding: 40px;
        }

        .page__title {
            text-align: left;
            font-size: 20px;
            font-weight: 400;
        }

        .page__desc {
            margin-top: 4px;
            color: rgba(0, 0, 0, .5);
            text-align: left;
            font-size: 14px;
        }
    </style>
</head>

<body>
<div class="page__hd">
    <div class="page__title">微信测试页面</div>
    <div class="page__desc" id="url"></div>
</div>
<div class="weui-form-preview">
    <div class="weui-form-preview__hd">
        <div class="weui-form-preview__item">
            <div class="weui-form-preview__label">昵称</div>
            <div class="weui-form-preview__value">
                <img id="avatar" src="${user.headImgUrl}"
                     style="width:30px;vertical-align: middle;border-radius: 2px;">&nbsp;<span
                        style="vertical-align: middle;">${user.nickname}</span></div>
        </div>
    </div>
    <div class="weui-form-preview__bd">
        <div class="weui-form-preview__item">
            <label class="weui-form-preview__label">性别</label>
            <span class="weui-form-preview__value">${user.sexDesc}</span>
        </div>
        <div class="weui-form-preview__item">
            <label class="weui-form-preview__label">国家</label>
            <span class="weui-form-preview__value">${user.country}</span>
        </div>
        <div class="weui-form-preview__item">
            <label class="weui-form-preview__label">地区</label>
            <span class="weui-form-preview__value">${user.province}</span>
        </div>
        <div class="weui-form-preview__item">
            <label class="weui-form-preview__label">城市</label>
            <span class="weui-form-preview__value">${user.city}</span>
        </div>
    </div>
    <div class="weui-form-preview__ft">
        <div class="weui-form-preview__bd">
            <span class="weui-form-preview__label" id="openId">${user.openId}</span>
        </div>
    </div>
</div>

<div class="weui-form__control-area">
    <div class="weui-cells__group weui-cells__group_form">
        <div class="weui-cells__title">微信支付测试</div>
        <div class="weui-cells weui-cells_form">
            <div class="weui-cell weui-cell_active">
                <div class="weui-cell__hd"><label class="weui-label">支付金额</label></div>
                <div class="weui-cell__bd">
                    <input id="totalFee" class="weui-input" placeholder="填写支付金额" value="0.01" type="number">
                </div>
            </div>
            <div class="weui-cell">
                <button onclick="pay()" class="weui-btn weui-btn_primary">立即支付</button>
            </div>
        </div>
    </div>
</div>

<div class="weui-form__control-area">
    <div class="weui-cells__group weui-cells__group_form">
        <div class="weui-cells__title">分享测试</div>
        <div class="weui-cells weui-cells_form">
            <div class="weui-cell weui-cell_active">
                <div class="weui-cell__hd"><label class="weui-label">分享标题</label></div>
                <div class="weui-cell__bd">
                    <input id="shareTitle" class="weui-input" placeholder="填写分享标题">
                </div>
            </div>
            <div class="weui-cell weui-cell_active">
                <div class="weui-cell__hd"><label class="weui-label">分享内容</label></div>
                <div class="weui-cell__bd">
                    <input id="shareContent" class="weui-input" placeholder="填写分享内容">
                </div>
            </div>
            <div class="weui-cell weui-cell_active">
                <div class="weui-cell__hd"><label class="weui-label">分享链接</label></div>
                <div class="weui-cell__bd">
                    <input id="shareLink" class="weui-input" placeholder="填写分享链接">
                </div>
            </div>
            <div class="weui-cell">
                <button onclick="setupShare()" class="weui-btn weui-btn_primary">设置</button>
            </div>
        </div>
    </div>
</div>

<div class="weui-form__control-area">
    <div class="weui-cells__group weui-cells__group_form">
        <div class="weui-cells__title">扫码测试</div>
        <div class="weui-cells weui-cells_form">
            <div class="weui-cell weui-cell_active weui-cell_switch">
                <div class="weui-cell__bd">扫描结果由微信处理</div>
                <div class="weui-cell__ft">
                    <input id="switchCP" class="weui-switch" type="checkbox" checked="checked">
                </div>
            </div>
            <div class="weui-cell weui-cell_active">
                <div class="weui-cell__hd"><label class="weui-label">扫码结果</label></div>
                <div class="weui-cell__bd" id="scanResult">
                </div>
            </div>
            <div class="weui-cell">
                <button onclick="scan()" class="weui-btn weui-btn_primary">立即扫码</button>
            </div>
        </div>
    </div>
</div>
<div id="successToast" style="display: none;">
    <div class="weui-mask_transparent"></div>
    <div class="weui-toast">
        <i class="weui-icon-success-no-circle weui-icon_toast"></i>
        <p class="weui-toast__content" id="successMsg">已完成</p>
    </div>
</div>
<div id="loadingToast" style="display: none;">
    <div class="weui-mask_transparent"></div>
    <div class="weui-toast">
        <i class="weui-loading weui-icon_toast"></i>
        <p class="weui-toast__content" id="loadingMsg">数据加载中</p>
    </div>
</div>
<div id="dialog" style="display: none;">
    <div class="weui-mask"></div>
    <div class="weui-dialog">
        <div class="weui-dialog__hd" id="dialogHeader"><strong class="weui-dialog__title"
                                                               id="dialogHeaderContent">弹窗标题</strong></div>
        <div class="weui-dialog__bd" id="dialogBody">弹窗内容，告知当前状态、信息和解决方法，描述文字尽量控制在三行内</div>
        <div class="weui-dialog__ft" id="dialogFooter">
            <a href="javascript:;" class="weui-dialog__btn weui-dialog__btn_default" id="dialogCancel">辅助操作</a>
            <a href="javascript:;" class="weui-dialog__btn weui-dialog__btn_primary" id="dialogConfirm">主操作</a>
        </div>
    </div>
</div>
</body>
<script>
    var vConsole = new VConsole();
    $('#url').html(location.origin + location.pathname);
    $.get('/wx/jsapiSign', {url: encodeURI(window.location.href.split('#')[0]),}, function (res) {
        res.debug = true;
        res.jsApiList = [
            'chooseWXPay',
            'updateAppMessageShareData',
            'updateTimelineShareData',
            'hideAllNonBaseMenuItem',
            'scanQRCode',
        ];
        wx.config(res);
    });
    wx.ready(function (res) {
        console.log('jssdk ready', res);
    });
    wx.error(function (res) {
        console.log('jssdk error', res);
    });

    function pay() {
        $.get('/wx/testPay', {
            openId: $('#openId').html(),
            totalFee: $('#totalFee').val() * 100
        }, function (res) {
            var config = {
                appId: res.appId,
                timestamp: res.timeStamp,
                nonceStr: res.nonceStr,
                package: res.packageValue,
                signType: res.signType,
                paySign: res.paySign
            };
            config.success = function () {
                showSuccess('支付成功');
            };
            wx.chooseWXPay(config);
        });
    }

    function setupShare() {
        wx.updateAppMessageShareData({
            title: $('#shareTitle').val(),
            desc: $('#shareContent').val(),
            link: $('#shareLink').val(),
            imgUrl: $('#avatar').attr('src'),
            success: function () {
                showSuccess('设置成功1');
            }
        });
        wx.updateTimelineShareData({
            title: $('#shareTitle').val(),
            link: $('#shareLink').val(),
            imgUrl: $('#avatar').attr('src'),
            success: function () {
                showSuccess('设置成功2');
            }
        });
    }

    function scan() {
        wx.scanQRCode({
            needResult: $('#switchCP')[0].checked ? 0 : 1,
            scanType: ["qrCode", "barCode"],
            success: function (res) {
                $('#scanResult').html(res.resultStr);
            }
        });
    }

    function showDialog(options) {
        $('#dialogHeader').show();
        $('#dialogHeaderContent').html(options.title || '提示');
        if (options.showCancel === undefined) {
            options.showCancel = false;
        }
        if (options.showCancel) {
            $('#dialogCancel').show();
            $('#dialogCancel').html(options.cancelText || '取消');
            $('#dialogCancel').on('click', function () {
                options.cancel ? options.cancel() : hideDialog();
            })
        } else {
            $('#dialogCancel').hide();
        }
        $('#dialogConfirm').html(options.cancelText || '确定');
        $('#dialogConfirm').on('click', function () {
            options.confirm ? options.confirm() : hideDialog();
        });
        $('#dialogBody').html(options.message);
        $('#dialog').show(200);
    }

    function hideDialog() {
        $('#dialog').hide(200);
    }

    function showLoading(msg) {
        $('#loadingMsg').html(msg || '加载中');
        $('#loadingToast').show(200);
    }

    function hideLoading() {
        $('#loadingToast').hide(200);
    }

    function showSuccess(msg) {
        $('#successMsg').html(msg || '成功');
        $('#successToast').show(200);
        setTimeout(() => {
            $('#successToast').hide(200);
        }, 1500);
    }
</script>

</html>