/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.client;

import com.dingtalk.open.client.DefaultConfig;
import com.dingtalk.open.client.common.OpenService;
import com.dingtalk.open.client.common.SdkInitException;
import com.dingtalk.open.client.common.ServiceNotExistException;
import com.dingtalk.open.client.transport.FlowControlInvoke;
import com.dingtalk.open.client.transport.HttpRemoteInvoke;
import com.dingtalk.open.client.transport.ImmediatelyInvoke;
import com.dingtalk.open.client.transport.OpenServiceProxy;
import com.dingtalk.open.client.utils.PackageScan;
import com.dingtalk.open.client.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Set;

public class ServiceFactory
implements Closeable {
    private static ServiceFactory serviceFactory;
    private Object serviceProxy;
    private Set<Class<?>> apiServiceSet;
    private HttpRemoteInvoke httpRemoteInvoke;

    private ServiceFactory(DefaultConfig defaultConfig) throws SdkInitException {
        this.apiServiceSet = this.scanService(defaultConfig.getApiBasePackage());
        if (this.apiServiceSet.size() == 0) {
            throw new SdkInitException("\u5728\u5305[" + defaultConfig.getApiBasePackage() + "]\u4e0b\u672a\u626b\u63cf\u5230\u4efb\u4f55\u9489\u9489\u5f00\u653e\u5e73\u53f0API");
        }
        Class[] apiServices = new Class[this.apiServiceSet.size()];
        this.apiServiceSet.toArray(apiServices);
        this.httpRemoteInvoke = defaultConfig.getFolwControl() != null && defaultConfig.getFolwControl().getIsUse() ? new FlowControlInvoke(defaultConfig, 1) : new ImmediatelyInvoke(defaultConfig);
        this.serviceProxy = Proxy.newProxyInstance(ServiceFactory.class.getClassLoader(), apiServices, (InvocationHandler)new OpenServiceProxy(this.apiServiceSet, defaultConfig, this.httpRemoteInvoke));
    }

    public static final synchronized ServiceFactory getInstance() throws SdkInitException {
        if (serviceFactory != null) {
            return serviceFactory;
        }
        return ServiceFactory.getInstance(new DefaultConfig());
    }

    public static final synchronized ServiceFactory getInstance(DefaultConfig defaultConfig) throws SdkInitException {
        if (defaultConfig == null) {
            defaultConfig = new DefaultConfig();
        }
        if (StringUtils.isEmpty(defaultConfig.getApiBasePackage()) || StringUtils.isEmpty(defaultConfig.getApiDomain())) {
            throw new SdkInitException("\u521d\u59cb\u5316\u9489\u9489SDK\u5931\u8d25,\u914d\u7f6e\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (defaultConfig.getFolwControl().getIsUse() && defaultConfig.getFolwControl().getMaxQpm() > 24000) {
            throw new SdkInitException("\u521d\u59cb\u5316\u9489\u9489SDK\u5931\u8d25,\u6700\u5927QPM\u4e0d\u5141\u8bb8\u8d85\u8fc724000");
        }
        if (serviceFactory == null) {
            serviceFactory = new ServiceFactory(defaultConfig);
        }
        return serviceFactory;
    }

    public <T> T getOpenService(Class<T> clazz) throws ServiceNotExistException {
        if (!this.apiServiceSet.contains(clazz)) {
            throw new ServiceNotExistException("\u9489\u9489\u5f00\u653e\u5e73\u53f0SDK\u4e0d\u652f\u6301API: " + clazz.getCanonicalName());
        }
        return (T)this.serviceProxy;
    }

    private Set<Class<?>> scanService(String openApiBasePackage) {
        LinkedHashSet result = new LinkedHashSet();
        Set<Class<?>> classes = PackageScan.scan(openApiBasePackage);
        for (Class<?> clazz : classes) {
            OpenService o = clazz.getAnnotation(OpenService.class);
            if (o == null || !clazz.isInterface()) continue;
            result.add(clazz);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.httpRemoteInvoke.close();
    }
}

