/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.client.transport;

import com.alibaba.fastjson.JSON;
import com.dingtalk.open.client.DefaultConfig;
import com.dingtalk.open.client.common.OpenAPI;
import com.dingtalk.open.client.transport.ApiAttr;
import com.dingtalk.open.client.transport.HttpRemoteInvoke;
import com.dingtalk.open.client.transport.HttpRequestHelper;
import com.dingtalk.open.client.transport.OpenResponse;
import com.dingtalk.open.client.transport.OpenResponseCallback;
import com.dingtalk.open.client.transport.RequestData;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControlInvoke
implements HttpRemoteInvoke {
    private static final Logger mainLogger = LoggerFactory.getLogger(FlowControlInvoke.class);
    private static final Logger sdkLogger = LoggerFactory.getLogger((String)"DING_OPEN_CLIENT_SDK_LOGGER");
    private AsyncHttpClient asyncHttpClient;
    private BlockingQueue<Runnable> queue;
    private ScheduledThreadPoolExecutor requestPool;
    private ReentrantLock lock = new ReentrantLock();
    private long requestTime = 0L;
    private int sendRequestPeriod;
    private long taskNum = 0L;

    public FlowControlInvoke(final DefaultConfig defaultConfig, int printQueueSizePeriod) {
        this.requestPool = new ScheduledThreadPoolExecutor(defaultConfig.getFolwControl().getThreadPoolSize());
        this.queue = this.requestPool.getQueue();
        this.sendRequestPeriod = 60000 / defaultConfig.getFolwControl().getMaxQpm();
        this.requestPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                FlowControlInvoke.this.taskNum++;
                HashMap<String, Object> base = new HashMap<String, Object>();
                base.put("max_qpm", defaultConfig.getFolwControl().getMaxQpm());
                base.put("send_request_period", FlowControlInvoke.this.sendRequestPeriod + "ms");
                HashMap<String, Integer> requestQueue = new HashMap<String, Integer>();
                requestQueue.put("size", FlowControlInvoke.this.queue.size());
                requestQueue.put("remainingCapacity", FlowControlInvoke.this.queue.remainingCapacity());
                HashMap<String, Integer> threadPool = new HashMap<String, Integer>();
                threadPool.put("core_size", FlowControlInvoke.this.requestPool.getCorePoolSize());
                threadPool.put("current_size", FlowControlInvoke.this.requestPool.getPoolSize());
                threadPool.put("active_size", FlowControlInvoke.this.requestPool.getActiveCount());
                threadPool.put("max_size", FlowControlInvoke.this.requestPool.getMaximumPoolSize());
                threadPool.put("largest_size", FlowControlInvoke.this.requestPool.getLargestPoolSize());
                HashMap<String, Long> task = new HashMap<String, Long>();
                task.put("all_count", FlowControlInvoke.this.requestPool.getTaskCount() - FlowControlInvoke.this.taskNum);
                task.put("completed_count", FlowControlInvoke.this.requestPool.getCompletedTaskCount() - FlowControlInvoke.this.taskNum + 1L);
                HashMap<String, HashMap<String, Object>> logMap = new HashMap<String, HashMap<String, Object>>();
                logMap.put("base", base);
                logMap.put("request_queue", requestQueue);
                logMap.put("thread_pool", threadPool);
                logMap.put("task", task);
                sdkLogger.info(JSON.toJSONString(logMap));
            }
        }, 0L, printQueueSizePeriod, TimeUnit.SECONDS);
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setConnectTimeout(defaultConfig.getGlobalHttpConfig().getConnectTimeout());
        builder.setReadTimeout(defaultConfig.getGlobalHttpConfig().getReadTimeout());
        builder.setRequestTimeout(defaultConfig.getGlobalHttpConfig().getRequestTimeout());
        builder.setMaxRequestRetry(defaultConfig.getGlobalHttpConfig().getMaxRequestRetry());
        this.asyncHttpClient = new AsyncHttpClient(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTime() {
        try {
            this.lock.lock();
            long t = System.currentTimeMillis();
            this.requestTime = this.requestTime == 0L ? t : (t - this.requestTime < (long)this.sendRequestPeriod ? (this.requestTime += (long)this.sendRequestPeriod) : t);
            long l = this.requestTime;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public OpenResponse execute(final RequestData requestData) throws Exception {
        requestData.recordStartExecuteTime();
        final HttpAsyncRequestTask requestTask = new HttpAsyncRequestTask();
        long expectedExcuteTime = this.getTime();
        requestData.setExpectedQuitQueueTime(expectedExcuteTime);
        this.requestPool.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    requestData.recordActualQuitQueueTime();
                    ApiAttr apiAttr = requestData.getApiAttr();
                    String fullUrl = requestData.getFullUrl();
                    Map<String, Object> postObj = requestData.getPostObj();
                    String requestId = requestData.getRequestId();
                    String finalPostFileKey = requestData.getFinalPostFileKey();
                    File finalPostFile = requestData.getFinalPostFile();
                    switch (apiAttr.getHttpMethod()) {
                        case POST: {
                            if (apiAttr.getPostType() == OpenAPI.PostType.JSON) {
                                HttpRequestHelper.httpRequestJson(requestTask.getHttpCallBack(), FlowControlInvoke.this.asyncHttpClient, requestId, apiAttr.getRequestTimeout(), "POST", fullUrl, postObj);
                                break;
                            }
                            if (apiAttr.getPostType() != OpenAPI.PostType.FILE) break;
                            HttpRequestHelper.httpRequestFile(requestTask.getHttpCallBack(), FlowControlInvoke.this.asyncHttpClient, requestId, apiAttr.getRequestTimeout(), fullUrl, finalPostFileKey, finalPostFile);
                            break;
                        }
                        case GET: {
                            HttpRequestHelper.httpRequestJson(requestTask.getHttpCallBack(), FlowControlInvoke.this.asyncHttpClient, requestId, apiAttr.getRequestTimeout(), "GET", fullUrl, null);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    OpenResponse openResponse = new OpenResponse();
                    openResponse.setThrowable(e);
                    requestTask.getHttpCallBack().onCallBack(openResponse);
                }
            }
        }, expectedExcuteTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        requestTask.pause();
        requestData.recordEndExecuteTime();
        return requestTask.getOpenResponse();
    }

    @Override
    public void close() {
        this.requestPool.shutdown();
        this.asyncHttpClient.close();
    }

    private class HttpAsyncRequestTask {
        private CountDownLatch latch = new CountDownLatch(1);
        private OpenResponse openResponse;
        private OpenResponseCallback httpCallBack;

        public HttpAsyncRequestTask() {
            this.httpCallBack = new OpenResponseCallback(){

                @Override
                public void onCallBack(OpenResponse response) {
                    HttpAsyncRequestTask.this.openResponse = response;
                    HttpAsyncRequestTask.this.latch.countDown();
                }
            };
        }

        public void pause() throws InterruptedException {
            this.latch.await();
        }

        public OpenResponse getOpenResponse() {
            return this.openResponse;
        }

        public OpenResponseCallback getHttpCallBack() {
            return this.httpCallBack;
        }
    }
}

