/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.client.transport;

import com.alibaba.fastjson.JSON;
import com.dingtalk.open.client.transport.OpenResponse;
import com.dingtalk.open.client.transport.OpenResponseCallback;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.Part;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public class HttpRequestHelper {
    public static OpenResponse httpRequestJson(final OpenResponseCallback callback, AsyncHttpClient asyncHttpClient, String requestId, int requestTimeout, String httpMethod, String url, Object requestJsonObject) {
        final OpenResponse openResponse = new OpenResponse();
        try {
            RequestBuilder requestBuilder = new RequestBuilder();
            requestBuilder.setUrl(url);
            requestBuilder.setRequestTimeout(requestTimeout);
            requestBuilder.setHeader("reqId", requestId);
            requestBuilder.setHeader("Content-Type", "application/json");
            if ("GET".equalsIgnoreCase(httpMethod)) {
                requestBuilder.setMethod("GET");
            } else if ("POST".equalsIgnoreCase(httpMethod)) {
                requestBuilder.setMethod("POST");
                requestBuilder.setBody(JSON.toJSONString((Object)requestJsonObject));
                requestBuilder.setBodyEncoding("utf-8");
            } else {
                throw new Exception("http method\u53ea\u652f\u6301get\u3001post");
            }
            Request request = requestBuilder.build();
            if (callback == null) {
                Response response = (Response)asyncHttpClient.executeRequest(request).get();
                openResponse.setHttpCode(response.getStatusCode());
                openResponse.setJsonResult(response.getResponseBody("utf-8"));
            } else {
                asyncHttpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Void>(){

                    public void onThrowable(Throwable t) {
                        openResponse.setThrowable(t);
                        callback.onCallBack(openResponse);
                    }

                    public Void onCompleted(Response response) throws Exception {
                        openResponse.setHttpCode(response.getStatusCode());
                        openResponse.setJsonResult(response.getResponseBody("utf-8"));
                        callback.onCallBack(openResponse);
                        return null;
                    }
                });
            }
        }
        catch (Throwable e) {
            openResponse.setThrowable(e);
        }
        return openResponse;
    }

    public static OpenResponse httpRequestFile(final OpenResponseCallback callback, AsyncHttpClient asyncHttpClient, String requestId, int requestTimeout, String url, String finalPostFileKey, File finalPostFile) {
        final OpenResponse openResponse = new OpenResponse();
        try {
            RequestBuilder requestBuilder = new RequestBuilder();
            requestBuilder.setUrl(url);
            requestBuilder.setRequestTimeout(requestTimeout);
            requestBuilder.setHeader("reqId", requestId);
            requestBuilder.setMethod("POST");
            ByteArrayPart part = new ByteArrayPart("media", FileUtils.readFileToByteArray((File)finalPostFile), "multipart/form-data", Charset.forName("utf-8"), finalPostFile.getName());
            requestBuilder.addBodyPart((Part)part);
            Request request = requestBuilder.build();
            if (callback == null) {
                Response response = (Response)asyncHttpClient.executeRequest(request).get();
                openResponse.setHttpCode(response.getStatusCode());
                openResponse.setJsonResult(response.getResponseBody("utf-8"));
            } else {
                asyncHttpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Void>(){

                    public void onThrowable(Throwable t) {
                        openResponse.setThrowable(t);
                        callback.onCallBack(openResponse);
                    }

                    public Void onCompleted(Response response) throws Exception {
                        openResponse.setHttpCode(response.getStatusCode());
                        openResponse.setJsonResult(response.getResponseBody("utf-8"));
                        callback.onCallBack(openResponse);
                        return null;
                    }
                });
            }
        }
        catch (Throwable e) {
            openResponse.setThrowable(e);
        }
        return openResponse;
    }
}

