/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.client.transport;

import com.dingtalk.open.client.DefaultConfig;
import com.dingtalk.open.client.common.OpenAPI;
import com.dingtalk.open.client.transport.ApiAttr;
import com.dingtalk.open.client.transport.HttpRemoteInvoke;
import com.dingtalk.open.client.transport.HttpRequestHelper;
import com.dingtalk.open.client.transport.OpenResponse;
import com.dingtalk.open.client.transport.RequestData;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediatelyInvoke
implements HttpRemoteInvoke {
    private static final Logger mainLogger = LoggerFactory.getLogger(ImmediatelyInvoke.class);
    private AsyncHttpClient asyncHttpClient;

    public ImmediatelyInvoke(DefaultConfig defaultConfig) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setConnectTimeout(defaultConfig.getGlobalHttpConfig().getConnectTimeout());
        builder.setReadTimeout(defaultConfig.getGlobalHttpConfig().getReadTimeout());
        builder.setRequestTimeout(defaultConfig.getGlobalHttpConfig().getRequestTimeout());
        builder.setMaxRequestRetry(defaultConfig.getGlobalHttpConfig().getMaxRequestRetry());
        this.asyncHttpClient = new AsyncHttpClient(builder.build());
    }

    @Override
    public OpenResponse execute(RequestData requestData) throws Exception {
        requestData.recordStartExecuteTime();
        ApiAttr apiAttr = requestData.getApiAttr();
        String fullUrl = requestData.getFullUrl();
        Map<String, Object> postObj = requestData.getPostObj();
        String requestId = requestData.getRequestId();
        String finalPostFileKey = requestData.getFinalPostFileKey();
        File finalPostFile = requestData.getFinalPostFile();
        OpenResponse openResponse = null;
        switch (apiAttr.getHttpMethod()) {
            case POST: {
                if (apiAttr.getPostType() == OpenAPI.PostType.JSON) {
                    openResponse = HttpRequestHelper.httpRequestJson(null, this.asyncHttpClient, requestId, apiAttr.getRequestTimeout(), "POST", fullUrl, postObj);
                    break;
                }
                if (apiAttr.getPostType() == OpenAPI.PostType.FILE) {
                    openResponse = HttpRequestHelper.httpRequestFile(null, this.asyncHttpClient, requestId, apiAttr.getRequestTimeout(), fullUrl, finalPostFileKey, finalPostFile);
                    break;
                }
                throw new Exception("API\u65b9\u6cd5[" + requestData.getApiInfo() + "]\u7684\u53c2\u6570\u6ce8\u89e3[ParamAttr]\u4e0d\u5408\u6cd5,\u5bf9\u4e8ePOST\u7c7b\u578b\u7684\u8bf7\u6c42,location\u53d6\u503c\u53ea\u652f\u6301FILE\u548cJSON_CONTENT");
            }
            case GET: {
                openResponse = HttpRequestHelper.httpRequestJson(null, this.asyncHttpClient, requestId, apiAttr.getRequestTimeout(), "GET", fullUrl, null);
                break;
            }
            default: {
                throw new Exception("API\u65b9\u6cd5[" + requestData.getApiInfo() + "]\u7684\u6ce8\u89e3[OpenAPI]\u53c2\u6570[httpMethod]\u4e0d\u5408\u6cd5");
            }
        }
        requestData.recordEndExecuteTime();
        return openResponse;
    }

    @Override
    public void close() {
        this.asyncHttpClient.close();
    }
}

