/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.client.transport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.open.client.DefaultConfig;
import com.dingtalk.open.client.common.OpenAPI;
import com.dingtalk.open.client.common.ParamAttr;
import com.dingtalk.open.client.common.SdkInitException;
import com.dingtalk.open.client.common.ServiceException;
import com.dingtalk.open.client.transport.ApiAttr;
import com.dingtalk.open.client.transport.HttpRemoteInvoke;
import com.dingtalk.open.client.transport.OpenResponse;
import com.dingtalk.open.client.transport.RequestData;
import com.dingtalk.open.client.utils.StringUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenServiceProxy
implements InvocationHandler {
    private static final Logger mainLogger = LoggerFactory.getLogger(OpenServiceProxy.class);
    private static final Logger httpInvokeLogger = LoggerFactory.getLogger((String)"HTTP_INVOKE_LOGGER");
    private Map<String, ApiAttr> apiAttrMap;
    private DefaultConfig defaultConfig;
    private HttpRemoteInvoke httpRemoteInvoke;

    public OpenServiceProxy(Set<Class<?>> apiServices, DefaultConfig defaultConfig, HttpRemoteInvoke httpRemoteInvoke) throws SdkInitException {
        if (apiServices.size() == 0) {
            throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,\u5f85\u521d\u59cb\u5316\u7684API\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.defaultConfig = defaultConfig;
        this.apiAttrMap = new HashMap<String, ApiAttr>();
        this.parseApi(apiServices, defaultConfig.getApiDomain());
        this.checkCustomHttpConfig();
        this.httpRemoteInvoke = httpRemoteInvoke;
    }

    private void checkCustomHttpConfig() throws SdkInitException {
        if (this.defaultConfig.getCustomHttpConfig() != null) {
            for (String key : this.defaultConfig.getCustomHttpConfig().keySet()) {
                if (this.apiAttrMap.containsKey(key)) continue;
                throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,\u4e3aAPI[" + key + "]\u8bbe\u7f6e\u7f51\u7edc\u8d85\u65f6\u65f6\u95f4\u53c2\u6570\u65e0\u6548,\u56e0\u4e3a\u8be5API\u4e0d\u5b58\u5728");
            }
        }
    }

    private void initFullUrl(ApiAttr apiAttr, Method apiMethod, OpenAPI openAPI, String openApiDomain) {
        String fullUrl = (openApiDomain.endsWith("/") ? openApiDomain.substring(0, openApiDomain.length() - 1) : openApiDomain) + (openAPI.uriPath().startsWith("/") ? openAPI.uriPath() : "/" + openAPI.uriPath());
        apiAttr.setUrl(fullUrl);
    }

    private void initApiParams(ApiAttr apiAttr, Method apiMethod, Class<?> clazz) throws SdkInitException {
        ArrayList<ApiAttr.ApiParam> apiParams = new ArrayList<ApiAttr.ApiParam>();
        int emptyParamKeyTotal = 0;
        int fileParamTotal = 0;
        for (int i = 0; i < apiMethod.getParameterAnnotations().length; ++i) {
            Annotation[] paramAnnotations = apiMethod.getParameterAnnotations()[i];
            if (paramAnnotations.length == 0) {
                throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u53c2\u6570\u9700\u8981\u8bbe\u7f6e\u6ce8\u89e3[ParamAttr]");
            }
            ApiAttr.ApiParam apiParam = new ApiAttr.ApiParam();
            apiParam.setIndex(i);
            boolean hasParamAttr = false;
            for (Annotation annotation : paramAnnotations) {
                if (!(annotation instanceof ParamAttr)) continue;
                ParamAttr paramAttr = (ParamAttr)annotation;
                if (paramAttr.location() == ParamAttr.Location.URL) {
                    if (StringUtils.isEmpty(paramAttr.paramKey())) {
                        throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u53c2\u6570\u8bbe\u7f6e\u7684\u6ce8\u89e3[ParamAttr]\u4e0d\u6b63\u786e,\u5bf9\u4e8eLocation.URL\u7c7b\u578b\u7684\u53c2\u6570,\u4e0d\u5141\u8bb8\u8bbe\u7f6ekey\u4e3a\u7a7a");
                    }
                } else if (paramAttr.location() == ParamAttr.Location.JSON_CONTENT) {
                    if (StringUtils.isEmpty(paramAttr.paramKey())) {
                        ++emptyParamKeyTotal;
                    }
                } else if (paramAttr.location() == ParamAttr.Location.FILE) {
                    ++fileParamTotal;
                    if (File.class != apiMethod.getParameterTypes()[i]) {
                        throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u53c2\u6570\u8bbe\u7f6e\u7684\u6ce8\u89e3[ParamAttr]\u4e0d\u6b63\u786e,\u5bf9\u4e8eLocation.FILE\u7c7b\u578b\u7684\u53c2\u6570,\u4f20\u5165\u7684\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u4e3aFile");
                    }
                    if (StringUtils.isEmpty(paramAttr.paramKey())) {
                        throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u53c2\u6570\u8bbe\u7f6e\u7684\u6ce8\u89e3[ParamAttr]\u4e0d\u6b63\u786e,\u5bf9\u4e8eLocation.FILE\u7c7b\u578b\u7684\u53c2\u6570,\u4e0d\u5141\u8bb8\u8bbe\u7f6ekey\u4e3a\u7a7a");
                    }
                }
                apiParam.setKey(paramAttr.paramKey());
                apiParam.setLocation(paramAttr.location());
                hasParamAttr = true;
                break;
            }
            if (!hasParamAttr) {
                throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u53c2\u6570\u9700\u8981\u8bbe\u7f6e\u6ce8\u89e3[ParamAttr]");
            }
            if (emptyParamKeyTotal > 1) {
                throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u53c2\u6570\u8bbe\u7f6e\u7684\u6ce8\u89e3[ParamAttr]\u4e0d\u6b63\u786e,\u5bf9\u4e8eLocation.JSON_CONTENT\u7c7b\u578b\u7684\u53c2\u6570,\u6700\u591a\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u53c2\u6570\u7684key\u4e3a\u7a7a");
            }
            if (fileParamTotal > 1) {
                throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u53c2\u6570\u8bbe\u7f6e\u7684\u6ce8\u89e3[ParamAttr]\u4e0d\u6b63\u786e,\u5bf9\u4e8eLocation.FILE\u7c7b\u578b\u7684\u53c2\u6570,\u6700\u591a\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a");
            }
            apiParams.add(apiParam);
        }
        apiAttr.setApiParams(apiParams);
    }

    private void initPostType(ApiAttr apiAttr) {
        if (apiAttr.getHttpMethod() == OpenAPI.HttpMethod.POST) {
            apiAttr.setPostType(OpenAPI.PostType.JSON);
            if (apiAttr.getApiParams() != null) {
                for (ApiAttr.ApiParam apiParam : apiAttr.getApiParams()) {
                    if (apiParam.getLocation() != ParamAttr.Location.FILE) continue;
                    apiAttr.setPostType(OpenAPI.PostType.FILE);
                }
            }
        }
    }

    private void initReturnClass(ApiAttr apiAttr, Method apiMethod, Class<?> clazz) throws SdkInitException {
        ApiAttr.ReturnClass returnClass = new ApiAttr.ReturnClass();
        Type genericReturnType = apiMethod.getGenericReturnType();
        if (ParameterizedType.class.isAssignableFrom(genericReturnType.getClass())) {
            Type rawType = ((ParameterizedType)genericReturnType).getRawType();
            if (!List.class.equals((Object)rawType)) {
                throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u8fd4\u56de\u7c7b\u578b\u5b9a\u4e49\u4e3a\u6cdb\u578b,\u76ee\u524d\u4ec5\u652f\u6301[List<T>]");
            }
            returnClass.setList(true);
            Type argumentsType = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
            returnClass.setClazz((Class)argumentsType);
        } else {
            returnClass.setList(false);
            returnClass.setClazz((Class)genericReturnType);
        }
        apiAttr.setReturnClass(returnClass);
    }

    private void initRequestConfig(ApiAttr apiAttr, OpenAPI openAPI) throws SdkInitException {
        DefaultConfig.HttpConfig customHttpConfig;
        int requestTimeout = this.defaultConfig.getGlobalHttpConfig().getRequestTimeout();
        if (openAPI.requestTimeout() != 60000) {
            requestTimeout = openAPI.requestTimeout();
        }
        if (this.defaultConfig.getCustomHttpConfig() != null && (customHttpConfig = this.defaultConfig.getCustomHttpConfig().get(openAPI.uriPath())) != null) {
            requestTimeout = customHttpConfig.getRequestTimeout();
        }
        apiAttr.setRequestTimeout(requestTimeout);
    }

    private void parseApi(Set<Class<?>> apiServices, String openApiDomain) throws SdkInitException {
        for (Class<?> clazz : apiServices) {
            for (Method apiMethod : clazz.getMethods()) {
                ApiAttr apiAttr = new ApiAttr();
                OpenAPI openAPI = apiMethod.getAnnotation(OpenAPI.class);
                if (this.apiAttrMap.get(openAPI.uriPath()) != null) {
                    throw new SdkInitException("\u521d\u59cb\u5316\u5931\u8d25,API[" + clazz.getCanonicalName() + "." + apiMethod.getName() + "]\u4e2d\u7684\u6ce8\u89e3[OpenAPI]\u53c2\u6570[urlPath]\u7684\u503c[" + openAPI.uriPath() + "]\u91cd\u590d\u4e86");
                }
                this.initFullUrl(apiAttr, apiMethod, openAPI, openApiDomain);
                apiAttr.setHttpMethod(openAPI.httpMethod());
                this.initApiParams(apiAttr, apiMethod, clazz);
                this.initPostType(apiAttr);
                this.initReturnClass(apiAttr, apiMethod, clazz);
                this.initRequestConfig(apiAttr, openAPI);
                apiAttr.setResultJsonKey(openAPI.resultJsonKey());
                this.apiAttrMap.put(openAPI.uriPath(), apiAttr);
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        JSONObject json;
        ApiAttr apiAttr;
        Long endExcuteTime;
        Long actualQuitQueueTime;
        Long expectedQuitQueueTime;
        Long startExcuteTime;
        Throwable throwable;
        String responseJsonContent;
        String postJsonContent;
        int httpCode;
        long rt;
        String fullUrl;
        String api;
        String requestId;
        long t;
        block64: {
            String jsonResult;
            block62: {
                block63: {
                    block61: {
                        t = System.currentTimeMillis();
                        requestId = StringUtils.generateRequestId();
                        api = "";
                        fullUrl = "";
                        rt = 0L;
                        httpCode = 0;
                        postJsonContent = "";
                        responseJsonContent = "";
                        throwable = null;
                        startExcuteTime = 0L;
                        expectedQuitQueueTime = 0L;
                        actualQuitQueueTime = 0L;
                        endExcuteTime = 0L;
                        api = method.getDeclaringClass().getSimpleName() + "." + method.getName();
                        OpenAPI openAPI = method.getAnnotation(OpenAPI.class);
                        if (openAPI == null) {
                            throw new Exception("API\u65b9\u6cd5[" + api + "]\u4e0a\u9700\u8981\u6709[OpenAPI]\u6ce8\u89e3");
                        }
                        if (openAPI.uriPath() == null || openAPI.uriPath().isEmpty()) {
                            throw new Exception("API\u65b9\u6cd5[" + api + "]\u7684\u6ce8\u89e3[OpenAPI]\u53c2\u6570[urlPath]\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        apiAttr = this.apiAttrMap.get(openAPI.uriPath());
                        if (apiAttr == null) {
                            throw new Exception("\u8c03\u7528\u7684API[" + openAPI.uriPath() + "]\u6ca1\u6709\u521d\u59cb\u5316,\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
                        }
                        if (httpInvokeLogger.isDebugEnabled()) {
                            Object[] logArgs = new Object[]{requestId, JSON.toJSONString((Object)apiAttr)};
                            StringBuilder sb = new StringBuilder();
                            sb.append("reqId={}");
                            sb.append("\t");
                            sb.append("apiAttr={}");
                            httpInvokeLogger.debug(sb.toString(), logArgs);
                        }
                        if (apiAttr.getApiParams().size() != args.length) {
                            throw new Exception("\u8c03\u7528\u7684API[" + openAPI.uriPath() + "]\u7684\u53c2\u6570\u4e2a\u6570\u4e0e\u521d\u59cb\u5316\u65f6\u5f97\u5230\u7684\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d,API\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
                        }
                        HashMap<String, Object> postObj = new HashMap<String, Object>();
                        Object finalPostObj = null;
                        File finalPostFile = null;
                        String finalPostFileKey = null;
                        StringBuilder urlParam = new StringBuilder("?");
                        int urlParamNum = 0;
                        for (int i = 0; i < apiAttr.getApiParams().size(); ++i) {
                            ApiAttr.ApiParam apiParam = apiAttr.getApiParams().get(i);
                            if (apiParam.getLocation() == ParamAttr.Location.URL) {
                                if (args[i] == null) continue;
                                if (++urlParamNum > 1) {
                                    urlParam.append("&");
                                }
                                urlParam.append(apiParam.getKey());
                                urlParam.append("=");
                                urlParam.append(args[i]);
                                continue;
                            }
                            if (apiParam.getLocation() == ParamAttr.Location.JSON_CONTENT) {
                                if (StringUtils.isEmpty(apiParam.getKey())) {
                                    finalPostObj = args[i];
                                    continue;
                                }
                                if ("${runtime_key}".equals(apiParam.getKey())) {
                                    if (args[i] == null) continue;
                                    ParamAttr paramAttr = args[i].getClass().getAnnotation(ParamAttr.class);
                                    if (paramAttr == null) {
                                        throw new Exception("\u8c03\u7528\u7684API[" + openAPI.uriPath() + "]\u7684\u53c2\u6570\u6ce8\u89e3ParamAttr\u4f7f\u7528\u4e86 Constants.RUNTIME_PARAM_KEY,\u4f46\u5b9e\u9645\u4f20\u5165\u7684\u5bf9\u8c61\u5374\u6ca1\u6709\u63d0\u4f9b\u6ce8\u89e3 ParamAttr,API\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
                                    }
                                    if (StringUtils.isEmpty(paramAttr.paramKey())) {
                                        throw new Exception("\u8c03\u7528\u7684API[" + openAPI.uriPath() + "]\u7684\u53c2\u6570\u6ce8\u89e3ParamAttr\u4f7f\u7528\u4e86 Constants.RUNTIME_PARAM_KEY,\u5b9e\u9645\u4f20\u5165\u7684\u5bf9\u8c61\u63d0\u4f9b\u7684\u6ce8\u89e3\u91cc\u7684paramKey\u4e3a\u7a7a,API\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
                                    }
                                    postObj.put(paramAttr.paramKey(), args[i]);
                                    continue;
                                }
                                postObj.put(apiParam.getKey(), args[i]);
                                continue;
                            }
                            if (apiParam.getLocation() != ParamAttr.Location.FILE) continue;
                            finalPostFile = (File)args[i];
                            finalPostFileKey = apiParam.getKey();
                            if (finalPostFile != null && !StringUtils.isEmpty(finalPostFileKey)) continue;
                            throw new Exception("\u8c03\u7528\u7684API[" + openAPI.uriPath() + "]\u7684\u53c2\u6570\u6ce8\u89e3ParamAttr\u4f7f\u7528\u4e86 Location.FILE,\u4f46\u5b9e\u9645\u4f20\u5165\u7684\u5bf9\u8c61\u4e3anull\u6216ParamKey\u4e3a\u7a7a,API\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
                        }
                        fullUrl = urlParam.insert(0, apiAttr.getUrl()).toString();
                        postJsonContent = finalPostObj == null ? JSON.toJSONString(postObj) : JSON.toJSONString(finalPostObj);
                        RequestData requestData = new RequestData();
                        requestData.setApiAttr(apiAttr);
                        requestData.setFullUrl(fullUrl);
                        requestData.setRequestId(requestId);
                        requestData.setApiInfo(api);
                        requestData.setPostObj(postObj);
                        requestData.setFinalPostFileKey(finalPostFileKey);
                        requestData.setFinalPostFile(finalPostFile);
                        switch (apiAttr.getHttpMethod()) {
                            case POST: {
                                if (apiAttr.getPostType() == OpenAPI.PostType.JSON || apiAttr.getPostType() == OpenAPI.PostType.FILE) break;
                                throw new Exception("API\u65b9\u6cd5[" + api + "]\u7684\u53c2\u6570\u6ce8\u89e3[ParamAttr]\u4e0d\u5408\u6cd5,\u5bf9\u4e8ePOST\u7c7b\u578b\u7684\u8bf7\u6c42,location\u53d6\u503c\u53ea\u652f\u6301FILE\u548cJSON_CONTENT");
                            }
                            case GET: {
                                break;
                            }
                            default: {
                                throw new Exception("API\u65b9\u6cd5[" + api + "]\u7684\u6ce8\u89e3[OpenAPI]\u53c2\u6570[httpMethod]\u4e0d\u5408\u6cd5,httpMethod\u53d6\u503c\u53ea\u652f\u6301GET\u548cPOST");
                            }
                        }
                        OpenResponse openResponse = this.httpRemoteInvoke.execute(requestData);
                        startExcuteTime = requestData.getStartExecuteTime();
                        expectedQuitQueueTime = requestData.getExpectedQuitQueueTime();
                        actualQuitQueueTime = requestData.getActualQuitQueueTime();
                        endExcuteTime = requestData.getEndExecuteTime();
                        if (openResponse == null) {
                            throw new Exception("SDK\u7684\u8fd4\u56de\u503c\u4e3anull,\u8bf7\u8054\u7cfbruizhe.srz@alibaba-inc.com");
                        }
                        if (openResponse.getThrowable() != null) {
                            throw openResponse.getThrowable();
                        }
                        httpCode = openResponse.getHttpCode();
                        responseJsonContent = openResponse.getJsonResult();
                        if (openResponse.getHttpCode() != 200) {
                            throw new Exception("API\u65b9\u6cd5[" + api + "]\u7684 HTTP \u54cd\u5e94\u7801\u4e0d\u662f200,\u503c\u4e3a" + openResponse.getHttpCode() + ",\u8bf7\u8054\u7cfbruizhe.srz@alibaba-inc.com");
                        }
                        json = JSON.parseObject((String)openResponse.getJsonResult());
                        jsonResult = openResponse.getJsonResult();
                        Integer errcode = json.getInteger("errcode");
                        String errmsg = json.getString("errmsg");
                        if (errcode == null || StringUtils.isEmpty(errmsg)) {
                            throw new Exception("\u9489\u9489\u5f00\u653e\u5e73\u53f0\u63a5\u53e3[" + openAPI.uriPath() + "]\u54cd\u5e94\u7ed3\u679c\u7f3a\u5c11errcode\u6216errmsg\u5b57\u6bb5,\u8bf7\u8054\u7cfbruizhe.srz@alibaba-inc.com");
                        }
                        if (errcode != 0) {
                            throw new ServiceException(errcode.intValue(), errmsg);
                        }
                        if (!Void.class.equals(apiAttr.getReturnClass().getClazz()) && !Void.TYPE.equals(apiAttr.getReturnClass().getClazz())) break block61;
                        Object var33_33 = null;
                        long endTime = System.currentTimeMillis();
                        rt = endTime - t;
                        Object[] logArgs = new Object[]{requestId, api, fullUrl, rt, httpCode, postJsonContent, responseJsonContent, throwable == null ? null : throwable.toString()};
                        StringBuilder sb = new StringBuilder();
                        sb.append("reqId={}");
                        sb.append("\t");
                        sb.append("api={}");
                        sb.append("\t");
                        sb.append("url={}");
                        sb.append("\t");
                        sb.append("rt={}ms");
                        sb.append("\t");
                        if (actualQuitQueueTime == 0L) {
                            sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                            sb.append("\t");
                            sb.append("exe_start->exe_end=" + (endExcuteTime - startExcuteTime) + "ms");
                            sb.append("\t");
                            sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                            sb.append("\t");
                        } else {
                            sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                            sb.append("\t");
                            sb.append("exe_start->expected_quit_queue=" + (expectedQuitQueueTime - startExcuteTime) + "ms");
                            sb.append("\t");
                            sb.append("expected_quit_queue->actual_quit_queue=" + (actualQuitQueueTime - expectedQuitQueueTime) + "ms");
                            sb.append("\t");
                            sb.append("actual_quit_queue->exe_end=" + (endExcuteTime - actualQuitQueueTime) + "ms");
                            sb.append("\t");
                            sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                            sb.append("\t");
                        }
                        sb.append("http_code={}");
                        sb.append("\t");
                        sb.append("post_json_content={}");
                        sb.append("\t");
                        sb.append("response_json_content={}");
                        if (throwable != null) {
                            sb.append("\t");
                            sb.append("throwable={}");
                        }
                        if (httpCode == 200) {
                            httpInvokeLogger.info(sb.toString(), logArgs);
                        } else {
                            httpInvokeLogger.warn(sb.toString(), logArgs);
                        }
                        return var33_33;
                    }
                    if (!apiAttr.getReturnClass().isList()) break block62;
                    if (!StringUtils.isEmpty(apiAttr.getResultJsonKey())) break block63;
                    List list = JSON.parseArray((String)jsonResult, apiAttr.getReturnClass().getClazz());
                    long endTime = System.currentTimeMillis();
                    rt = endTime - t;
                    Object[] logArgs = new Object[]{requestId, api, fullUrl, rt, httpCode, postJsonContent, responseJsonContent, throwable == null ? null : throwable.toString()};
                    StringBuilder sb = new StringBuilder();
                    sb.append("reqId={}");
                    sb.append("\t");
                    sb.append("api={}");
                    sb.append("\t");
                    sb.append("url={}");
                    sb.append("\t");
                    sb.append("rt={}ms");
                    sb.append("\t");
                    if (actualQuitQueueTime == 0L) {
                        sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                        sb.append("\t");
                        sb.append("exe_start->exe_end=" + (endExcuteTime - startExcuteTime) + "ms");
                        sb.append("\t");
                        sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                        sb.append("\t");
                    } else {
                        sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                        sb.append("\t");
                        sb.append("exe_start->expected_quit_queue=" + (expectedQuitQueueTime - startExcuteTime) + "ms");
                        sb.append("\t");
                        sb.append("expected_quit_queue->actual_quit_queue=" + (actualQuitQueueTime - expectedQuitQueueTime) + "ms");
                        sb.append("\t");
                        sb.append("actual_quit_queue->exe_end=" + (endExcuteTime - actualQuitQueueTime) + "ms");
                        sb.append("\t");
                        sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                        sb.append("\t");
                    }
                    sb.append("http_code={}");
                    sb.append("\t");
                    sb.append("post_json_content={}");
                    sb.append("\t");
                    sb.append("response_json_content={}");
                    if (throwable != null) {
                        sb.append("\t");
                        sb.append("throwable={}");
                    }
                    if (httpCode == 200) {
                        httpInvokeLogger.info(sb.toString(), logArgs);
                    } else {
                        httpInvokeLogger.warn(sb.toString(), logArgs);
                    }
                    return list;
                }
                JSONArray array = json.getJSONArray(apiAttr.getResultJsonKey());
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < array.size(); ++i) {
                    list.add(array.getObject(i, apiAttr.getReturnClass().getClazz()));
                }
                ArrayList<Object> arrayList = list;
                long endTime = System.currentTimeMillis();
                rt = endTime - t;
                Object[] logArgs = new Object[]{requestId, api, fullUrl, rt, httpCode, postJsonContent, responseJsonContent, throwable == null ? null : throwable.toString()};
                StringBuilder sb = new StringBuilder();
                sb.append("reqId={}");
                sb.append("\t");
                sb.append("api={}");
                sb.append("\t");
                sb.append("url={}");
                sb.append("\t");
                sb.append("rt={}ms");
                sb.append("\t");
                if (actualQuitQueueTime == 0L) {
                    sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                    sb.append("\t");
                    sb.append("exe_start->exe_end=" + (endExcuteTime - startExcuteTime) + "ms");
                    sb.append("\t");
                    sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                    sb.append("\t");
                } else {
                    sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                    sb.append("\t");
                    sb.append("exe_start->expected_quit_queue=" + (expectedQuitQueueTime - startExcuteTime) + "ms");
                    sb.append("\t");
                    sb.append("expected_quit_queue->actual_quit_queue=" + (actualQuitQueueTime - expectedQuitQueueTime) + "ms");
                    sb.append("\t");
                    sb.append("actual_quit_queue->exe_end=" + (endExcuteTime - actualQuitQueueTime) + "ms");
                    sb.append("\t");
                    sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                    sb.append("\t");
                }
                sb.append("http_code={}");
                sb.append("\t");
                sb.append("post_json_content={}");
                sb.append("\t");
                sb.append("response_json_content={}");
                if (throwable != null) {
                    sb.append("\t");
                    sb.append("throwable={}");
                }
                if (httpCode == 200) {
                    httpInvokeLogger.info(sb.toString(), logArgs);
                } else {
                    httpInvokeLogger.warn(sb.toString(), logArgs);
                }
                return arrayList;
            }
            if (!StringUtils.isEmpty(apiAttr.getResultJsonKey())) break block64;
            Object object2 = JSON.parseObject((String)jsonResult, apiAttr.getReturnClass().getClazz());
            long endTime = System.currentTimeMillis();
            rt = endTime - t;
            Object[] logArgs = new Object[]{requestId, api, fullUrl, rt, httpCode, postJsonContent, responseJsonContent, throwable == null ? null : throwable.toString()};
            StringBuilder sb = new StringBuilder();
            sb.append("reqId={}");
            sb.append("\t");
            sb.append("api={}");
            sb.append("\t");
            sb.append("url={}");
            sb.append("\t");
            sb.append("rt={}ms");
            sb.append("\t");
            if (actualQuitQueueTime == 0L) {
                sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                sb.append("\t");
                sb.append("exe_start->exe_end=" + (endExcuteTime - startExcuteTime) + "ms");
                sb.append("\t");
                sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                sb.append("\t");
            } else {
                sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                sb.append("\t");
                sb.append("exe_start->expected_quit_queue=" + (expectedQuitQueueTime - startExcuteTime) + "ms");
                sb.append("\t");
                sb.append("expected_quit_queue->actual_quit_queue=" + (actualQuitQueueTime - expectedQuitQueueTime) + "ms");
                sb.append("\t");
                sb.append("actual_quit_queue->exe_end=" + (endExcuteTime - actualQuitQueueTime) + "ms");
                sb.append("\t");
                sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                sb.append("\t");
            }
            sb.append("http_code={}");
            sb.append("\t");
            sb.append("post_json_content={}");
            sb.append("\t");
            sb.append("response_json_content={}");
            if (throwable != null) {
                sb.append("\t");
                sb.append("throwable={}");
            }
            if (httpCode == 200) {
                httpInvokeLogger.info(sb.toString(), logArgs);
            } else {
                httpInvokeLogger.warn(sb.toString(), logArgs);
            }
            return object2;
        }
        try {
            object = json.getObject(apiAttr.getResultJsonKey(), apiAttr.getReturnClass().getClazz());
        }
        catch (Throwable th) {
            try {
                throwable = th;
                throw th;
            }
            catch (Throwable throwable2) {
                long endTime = System.currentTimeMillis();
                rt = endTime - t;
                Object[] logArgs = new Object[]{requestId, api, fullUrl, rt, httpCode, postJsonContent, responseJsonContent, throwable == null ? null : throwable.toString()};
                StringBuilder sb = new StringBuilder();
                sb.append("reqId={}");
                sb.append("\t");
                sb.append("api={}");
                sb.append("\t");
                sb.append("url={}");
                sb.append("\t");
                sb.append("rt={}ms");
                sb.append("\t");
                if (actualQuitQueueTime == 0L) {
                    sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                    sb.append("\t");
                    sb.append("exe_start->exe_end=" + (endExcuteTime - startExcuteTime) + "ms");
                    sb.append("\t");
                    sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                    sb.append("\t");
                } else {
                    sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
                    sb.append("\t");
                    sb.append("exe_start->expected_quit_queue=" + (expectedQuitQueueTime - startExcuteTime) + "ms");
                    sb.append("\t");
                    sb.append("expected_quit_queue->actual_quit_queue=" + (actualQuitQueueTime - expectedQuitQueueTime) + "ms");
                    sb.append("\t");
                    sb.append("actual_quit_queue->exe_end=" + (endExcuteTime - actualQuitQueueTime) + "ms");
                    sb.append("\t");
                    sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
                    sb.append("\t");
                }
                sb.append("http_code={}");
                sb.append("\t");
                sb.append("post_json_content={}");
                sb.append("\t");
                sb.append("response_json_content={}");
                if (throwable != null) {
                    sb.append("\t");
                    sb.append("throwable={}");
                }
                if (httpCode == 200) {
                    httpInvokeLogger.info(sb.toString(), logArgs);
                } else {
                    httpInvokeLogger.warn(sb.toString(), logArgs);
                }
                throw throwable2;
            }
        }
        long endTime = System.currentTimeMillis();
        rt = endTime - t;
        Object[] logArgs = new Object[]{requestId, api, fullUrl, rt, httpCode, postJsonContent, responseJsonContent, throwable == null ? null : throwable.toString()};
        StringBuilder sb = new StringBuilder();
        sb.append("reqId={}");
        sb.append("\t");
        sb.append("api={}");
        sb.append("\t");
        sb.append("url={}");
        sb.append("\t");
        sb.append("rt={}ms");
        sb.append("\t");
        if (actualQuitQueueTime == 0L) {
            sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
            sb.append("\t");
            sb.append("exe_start->exe_end=" + (endExcuteTime - startExcuteTime) + "ms");
            sb.append("\t");
            sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
            sb.append("\t");
        } else {
            sb.append("start->exe_start=" + (startExcuteTime - t) + "ms");
            sb.append("\t");
            sb.append("exe_start->expected_quit_queue=" + (expectedQuitQueueTime - startExcuteTime) + "ms");
            sb.append("\t");
            sb.append("expected_quit_queue->actual_quit_queue=" + (actualQuitQueueTime - expectedQuitQueueTime) + "ms");
            sb.append("\t");
            sb.append("actual_quit_queue->exe_end=" + (endExcuteTime - actualQuitQueueTime) + "ms");
            sb.append("\t");
            sb.append("exe_end->end=" + (endTime - endExcuteTime) + "ms");
            sb.append("\t");
        }
        sb.append("http_code={}");
        sb.append("\t");
        sb.append("post_json_content={}");
        sb.append("\t");
        sb.append("response_json_content={}");
        if (throwable != null) {
            sb.append("\t");
            sb.append("throwable={}");
        }
        if (httpCode == 200) {
            httpInvokeLogger.info(sb.toString(), logArgs);
        } else {
            httpInvokeLogger.warn(sb.toString(), logArgs);
        }
        return object;
    }
}

