/*
 * Decompiled with CFR 0.152.
 */
package fanwe;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Global {
    public static void doDeleteEmptyDir(String dir) {
        boolean success = new File(dir).delete();
        if (success) {
            System.out.println("Successfully deleted empty directory: " + dir);
        } else {
            System.out.println("Failed to delete empty directory: " + dir);
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = Global.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static int getTime() {
        Calendar calendar = Calendar.getInstance();
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(zoneOffset + dstOffset));
        Date date = calendar.getTime();
        Long time = date.getTime() / 1000L;
        return time.intValue();
    }

    public static Date getBeforeDate(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, amount);
        return calendar.getTime();
    }

    public static String getNowTime() {
        Calendar calendar = Calendar.getInstance();
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime());
    }

    public static String getTodayTime() {
        Calendar calendar = Calendar.getInstance();
        return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
    }

    public static void logPrint(Exception e) {
        Global.logPrint(e, "");
    }

    public static String mkdirs(boolean has_hh, boolean has_day) {
        File file;
        Calendar nowCalendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dir = String.valueOf(System.getProperty("user.dir")) + "/logs";
        if (has_day) {
            dir = String.valueOf(dir) + "/" + sdf.format(nowCalendar.getTime());
        }
        if (has_hh) {
            SimpleDateFormat sdfhh = new SimpleDateFormat("HH");
            dir = String.valueOf(dir) + "/" + sdfhh.format(nowCalendar.getTime());
        }
        if (!(file = new File(dir)).exists()) {
            file.mkdirs();
        }
        return dir;
    }

    public static void logPrint(String txt, String type, boolean has_hh, boolean has_day) {
        try {
            String dir = Global.mkdirs(has_hh, has_day);
            if (type.isEmpty()) {
                type = "root";
            }
            File file = new File(String.valueOf(dir) + "/" + type + ".txt");
            FileWriter out = new FileWriter(file, true);
            Throwable throwable = null;
            Object var8_10 = null;
            try (PrintWriter pw = new PrintWriter(out);){
                pw.println(txt);
                pw.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            System.out.println("file I/O error");
            System.out.println(ex);
        }
    }

    public static void setMonitor() {
        try {
            String dir = Global.mkdirs(false, false);
            File file = new File(String.valueOf(dir) + "/monitor.txt");
            FileWriter out = new FileWriter(file, false);
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter pw = new PrintWriter(out);){
                pw.println(Global.getTime());
                pw.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            System.out.println("file I/O error");
            System.out.println(ex);
        }
    }

    public static int getMonitor() {
        String monitor = String.valueOf(System.getProperty("user.dir")) + "/logs/monitor.txt";
        int monitor_time = 0;
        File file = new File(monitor);
        if (file.exists()) {
            try {
                BufferedReader bf = new BufferedReader(new FileReader(monitor));
                String s = null;
                s = bf.readLine();
                if (s != null) {
                    monitor_time = Integer.parseInt(s);
                }
                bf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return monitor_time;
    }

    public static void logPrint(Exception e, String type) {
        try {
            String dir = Global.mkdirs(false, true);
            if (type.isEmpty()) {
                type = "root";
            }
            File file = new File(String.valueOf(dir) + "/" + type + ".txt");
            FileWriter out = new FileWriter(file, true);
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter pw = new PrintWriter(out);){
                pw.println(String.valueOf(Global.getNowTime()) + " > ");
                e.printStackTrace(pw);
                pw.print("\r\n======================\r\n");
                pw.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            System.out.println("file I/O error");
            System.out.println(ex);
        }
    }
}

